/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib.Base;

import Jp.BuySmart.DddLib.Base.DddException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String hmac(String provider, String algorithm, String key, String value) throws DddException {
        if (key == null || key.length() == 0) {
            throw new DddException("M95", "key was null.");
        }
        if (value == null) {
            value = "";
        }
        int key_len = key.length() / 2;
        StringBuffer sb = null;
        try {
            Provider prov = (Provider)Class.forName(provider).newInstance();
            Security.addProvider(prov);
            byte[] keyByte = new byte[key_len];
            for (int i = 0; i < key_len; ++i) {
                keyByte[i] = (byte)Integer.parseInt(key.substring(i * 2, i * 2 + 2), 16);
            }
            SecretKeySpec sk = new SecretKeySpec(keyByte, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(sk);
            byte[] result = mac.doFinal(value.getBytes());
            sb = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                sb.append(HEX[Crypto.byte2int(result[i]) / 16]);
                sb.append(HEX[Crypto.byte2int(result[i]) % 16]);
            }
        }
        catch (Exception e) {
            throw new DddException("M95", e);
        }
        return sb.toString();
    }

    private static int byte2int(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public static String genHash(String id, String key, String value) {
        StringBuffer sb = null;
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            String colon = ":";
            sha1.update(id.getBytes());
            sha1.update(colon.getBytes());
            sha1.update(key.getBytes());
            sha1.update(colon.getBytes());
            sha1.update(value.getBytes());
            byte[] result = sha1.digest();
            sb = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                sb.append(HEX[Crypto.byte2int(result[i]) / 16]);
                sb.append(HEX[Crypto.byte2int(result[i]) % 16]);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

