/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib;

import Jp.BuySmart.DddLib.Base.Jdk13Helper;
import Jp.BuySmart.DddLib.DefaultConfig;
import Jp.BuySmart.DddLib.LoggerFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

class Config
extends Properties {
    public static final String GW_HOSTS = "GW_HOSTS";
    public static final String HTTP_PROXY_HOST = "HTTP_PROXY_HOST";
    public static final String SECRET = "SECRET";
    public static final String KEY_HA1 = "KEY_HA1";
    public static final String TRUSTED_HOSTS = "TRUSTED_HOSTS";
    public static final String ACCEPT_LANGUAGE = "ACCEPT_LANGUAGE";
    public static final String SSL_ALGORITHM = "SSL_ALGORITHM";
    public static final String TIMEOUT = "TIMEOUT";
    private static final String SEPARATOR = ",";

    public Config() {
        super(new Properties());
        Logger logger = LoggerFactory.getLogger();
        try {
            DefaultConfig res = DefaultConfig.getInstance();
            Enumeration<String> e = res.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = res.get(key);
                if (value == null && value.length() > 0) continue;
                this.defaults.setProperty(key, value);
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Cache exception from DefaultConfig.getInstance().", (Throwable)e);
        }
        logger.debug((Object)"***** DefaultConfig values *****");
        Enumeration<Object> e = this.defaults.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            logger.debug((Object)(key + " = " + this.defaults.get(key)));
        }
        logger.debug((Object)"***** DefaultConfig values *****");
    }

    public Object clone() {
        Config copy = new Config();
        Iterator<Object> i = this.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            copy.put(new String(key), new String(this.get(key)));
        }
        return copy;
    }

    private String get(String key) {
        String s = this.getProperty(key);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private void set(String key, String value) {
        this.setProperty(key, value);
    }

    public String getGWHostsRaw() {
        return this.get(GW_HOSTS);
    }

    public Vector getGWHosts() {
        if (this.getGWHostsRaw() == null) {
            return new Vector();
        }
        String[] hosts = Jdk13Helper.splitString(this.getGWHostsRaw(), SEPARATOR);
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < hosts.length; ++i) {
            v.add(hosts[i].trim());
        }
        return v;
    }

    public void setGWHostsRaw(String urls) {
        this.set(GW_HOSTS, urls);
    }

    public void setGWHosts(Collection urls) {
        StringBuffer buf = new StringBuffer();
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            if (buf.length() > 0) {
                buf.append(SEPARATOR);
            }
            buf.append(((String)i.next()).trim());
        }
        if (buf.length() <= 0) {
            throw new NoSuchElementException("No Element.");
        }
        this.setGWHostsRaw(buf.toString());
    }

    public String getSecret() {
        return this.get(SECRET);
    }

    public void setSecret(String secret) {
        this.set(SECRET, secret);
    }

    public String getKeyHA1() {
        return this.get(KEY_HA1);
    }

    public void setKeyHA1(String key) {
        this.set(KEY_HA1, key);
    }

    public String getTrustedHostsRaw() {
        return this.get(TRUSTED_HOSTS);
    }

    public Vector getTrustedHosts() {
        if (this.getTrustedHostsRaw() == null) {
            return new Vector();
        }
        String[] hosts = Jdk13Helper.splitString(this.getTrustedHostsRaw(), SEPARATOR);
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < hosts.length; ++i) {
            v.add(hosts[i].trim());
        }
        return v;
    }

    public void setTrustedHostsRaw(String urls) {
        this.set(TRUSTED_HOSTS, urls);
    }

    public void setTrustedHosts(Collection urls) {
        StringBuffer buf = new StringBuffer();
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            if (buf.length() > 0) {
                buf.append(SEPARATOR);
            }
            buf.append(((String)i.next()).trim());
        }
        if (buf.length() <= 0) {
            throw new NoSuchElementException("No Element.");
        }
        this.setTrustedHostsRaw(buf.toString());
    }

    public String getTimeOutRaw() {
        return this.get(TIMEOUT);
    }

    public void setTimeOutRaw(String sec) {
        this.set(TIMEOUT, sec);
    }

    public String getHttpProxyHost() {
        return this.get(HTTP_PROXY_HOST);
    }

    public void setHttpProxyHost(String url) {
        this.set(HTTP_PROXY_HOST, url);
    }

    public String getAcceptLanguage() {
        return this.get(ACCEPT_LANGUAGE);
    }

    public void setAcceptLanguage(String lang) {
        this.set(ACCEPT_LANGUAGE, lang);
    }

    public String getSslAlgorithm() {
        return this.get(SSL_ALGORITHM);
    }

    public void setSslAlgorithm(String name) {
        this.put(SSL_ALGORITHM, name);
    }
}

