/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib;

import Jp.BuySmart.DddLib.ActionResource;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageResource {
    protected static MessageResource instance = null;
    public static final String UNDEFINED = "undefined messege.";
    protected static final String BASE_NAME = ActionResource.class.getPackage().getName() + ".MErrMsg";
    protected HashMap msgMap = new HashMap();

    public static synchronized MessageResource getInstance() {
        if (instance == null) {
            instance = new MessageResource();
        }
        return instance;
    }

    protected MessageResource() {
        String lang = "en";
        this.msgMap.put(lang, ResourceBundle.getBundle(BASE_NAME, new Locale(lang, "")));
        lang = "ja";
        this.msgMap.put(lang, ResourceBundle.getBundle(BASE_NAME, new Locale(lang, "")));
    }

    public String find(String lang, String code) {
        ResourceBundle msgRes;
        String msg = null;
        if (lang == null || lang.length() == 0) {
            lang = "en";
        }
        if ((msgRes = (ResourceBundle)this.msgMap.get(lang)) == null) {
            msg = UNDEFINED;
        }
        try {
            msg = msgRes.getString(code);
            if (msg == null) {
                return UNDEFINED;
            }
        }
        catch (MissingResourceException e) {
            msg = UNDEFINED;
        }
        return msg;
    }

    public String find(String lang, String code, String option) {
        String message = this.find(lang, code);
        if (!message.equals(UNDEFINED) && option != null) {
            int idx = message.indexOf("%d");
            if (idx == -1) {
                idx = message.indexOf("%s");
            }
            if (idx != -1) {
                message = message.substring(0, idx) + option + message.substring(idx + 2);
            }
        }
        return message;
    }
}

