/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib;

import Jp.BuySmart.DddLib.Config;
import Jp.BuySmart.DddLib.Transaction;
import java.util.Hashtable;
import java.util.Map;

public class TransactionFactory {
    public static Transaction createInstance() {
        Config config = new Config();
        Transaction trans = new Transaction();
        trans.gwHostsRaw = config.getGWHostsRaw();
        trans.httpProxyHost = config.getHttpProxyHost();
        trans.secret = config.getSecret();
        trans.keyHA1 = config.getKeyHA1();
        trans.trustedHostsRaw = config.getTrustedHostsRaw();
        try {
            trans.timeout = Integer.parseInt(config.getTimeOutRaw());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        trans.sslAlgorithm = config.getSslAlgorithm();
        return trans;
    }

    public static Transaction createInstance(String secret, String key_ha1) {
        Transaction trans = TransactionFactory.createInstance();
        trans.secret = secret;
        trans.keyHA1 = key_ha1;
        return trans;
    }

    public static Map createRequest() {
        Hashtable<String, String> req = new Hashtable<String, String>();
        Config config = new Config();
        String value = config.getSecret();
        if (value != null && value.length() > 0) {
            req.put("secret", value);
        }
        if ((value = config.getKeyHA1()) != null && value.length() > 0) {
            req.put("key-ha1", value);
        }
        if ((value = config.getAcceptLanguage()) != null && value.length() > 0) {
            req.put("accept-language", value);
        }
        if ((value = config.getSslAlgorithm()) != null && value.length() > 0) {
            req.put("ssl-algorithm", value);
        }
        return req;
    }
}

