/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.CVS.GWLib;

import Jp.BuySmart.CVS.GWLib.CVSException;
import Jp.BuySmart.CVS.GWLib.CVSLogger;
import Jp.BuySmart.CVS.GWLib.RequestMessage;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;

class ComServer {
    public static final String CERT_FILE = "/jssecacerts";
    private final String VERSION = "1.0";
    protected final String CONTENT_LENGTH = "Content-Length";
    protected final int CL_TAG_LEN = "Content-Length".length();
    private final String KEYSTORE_PASSWD = "CVSCVS";
    private int timeout = 0;
    private int code = -1;
    private String message = null;
    private Logger logger = CVSLogger.getLogger();
    protected String sTrustedHosts = null;
    private boolean https = false;
    private Socket socket = null;
    private Socket tunnel = null;
    DataOutputStream dos = null;
    BufferedReader br = null;
    DataOutputStream t_dos = null;
    BufferedReader t_br = null;

    public URL getCertFileURL() {
        return this.getClass().getResource(CERT_FILE);
    }

    public ComServer(String string, int n) {
        this.sTrustedHosts = string;
        this.timeout = n;
    }

    public String getResponseMessage() {
        return this.message;
    }

    public int getResponseCode() {
        return this.code;
    }

    public void start(String string, String string2, RequestMessage requestMessage) throws CVSException {
        this.logger.info((Object)("=== SENDMSERVER to host=" + string + ", proxy=" + string2 + " ==="));
        try {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            this.checkProtocol(string);
            Hashtable hashtable = this.parseUrl(string);
            if (this.https) {
                this.useHttpsConnect((String)hashtable.get("host"), Integer.parseInt((String)hashtable.get("port")), string2, requestMessage);
            } else {
                this.useHttpConnect((String)hashtable.get("host"), Integer.parseInt((String)hashtable.get("port")), string2, requestMessage);
            }
            this.checkHttpStatusCode();
        }
        catch (CVSException cVSException) {
            String string3 = requestMessage.getCommand();
            boolean bl = string3.equals("entry");
            if (cVSException.getCode().equals("M13")) {
                this.logger.error((Object)"!!Connected timeout.", (Throwable)cVSException);
                if (bl) {
                    throw new CVSException("M31");
                }
            } else if (cVSException.getCode().equals("M11")) {
                this.logger.error((Object)("!!Could not connect payment server: " + string + "."), (Throwable)cVSException);
            } else if (cVSException.getCode().equals("M12")) {
                this.logger.error((Object)("!!Could not connect proxy server: " + string2 + "."), (Throwable)cVSException);
            } else if (cVSException.getCode().equals("M10")) {
                this.logger.error((Object)"!!error writing  to socket.", (Throwable)cVSException);
            } else if (cVSException.getCode().equals("M45")) {
                this.logger.error((Object)"!!fail to calculate HMAC.", (Throwable)cVSException);
            } else if (cVSException.getCode().equals("M21") && bl) {
                throw new CVSException("M31");
            }
            throw cVSException;
        }
        catch (Exception exception) {
            this.logger.error((Object)("!!Could not connect payment server: " + string + "."));
            throw new CVSException("M11");
        }
    }

    private void checkHttpStatusCode() throws CVSException {
        switch (this.code) {
            case 200: {
                break;
            }
            case 401: {
                throw new CVSException("M14");
            }
            case 403: {
                throw new CVSException("M15");
            }
            case 404: {
                throw new CVSException("M16");
            }
            case 500: {
                throw new CVSException("M17");
            }
            case 501: {
                throw new CVSException("M18");
            }
            case 503: {
                throw new CVSException("M19");
            }
            default: {
                throw new CVSException("M20", String.valueOf(this.code));
            }
        }
    }

    private Hashtable parseUrl(String string) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        int n2 = 0;
        n = string.indexOf("://");
        hashtable.put("protocol", string.substring(0, n));
        n2 = string.indexOf(":", n + 3);
        hashtable.put("host", string.substring(n + 3, n2));
        n = n2;
        n2 = string.indexOf("/", n);
        hashtable.put("port", string.substring(n + 1, n2));
        return hashtable;
    }

    private void checkProtocol(String string) throws CVSException {
        this.https = string.startsWith("https://");
        if (!this.https && !string.startsWith("http://")) {
            throw new CVSException("M11");
        }
    }

    private void checkCertificate() throws CVSException {
        try {
            ((SSLSocket)this.socket).startHandshake();
            SSLSession sSLSession = ((SSLSocket)this.socket).getSession();
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            boolean bl = false;
            String string = null;
            String string2 = "";
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                String string3 = ((Object)x509CertificateArray[i].getSubjectDN()).toString();
                int n = string3.indexOf("CN=");
                if (n == -1) continue;
                int n2 = string3.indexOf(",", n += 3);
                string = n2 != -1 ? string3.substring(n, n2) : string3.substring(n);
                this.logger.debug((Object)("SSL Trust Server = " + string));
                bl = this.isTrustHost(string);
                if (bl) break;
                string2 = string + " ";
            }
            if (!bl) {
                this.logger.error((Object)("!!mismatch host name: " + string2));
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new CVSException("M11");
        }
    }

    private void doTunnelHandshake(String string, int n) throws CVSException {
        try {
            this.t_dos = new DataOutputStream(this.tunnel.getOutputStream());
            this.t_dos.writeBytes("CONNECT " + string + ":" + n + " HTTP/1.0\r\n\r\n");
            this.t_dos.flush();
            this.t_br = new BufferedReader(new InputStreamReader(this.tunnel.getInputStream(), "8859_1"));
            String string2 = this.t_br.readLine();
            String string3 = null;
            while (string2 != null && (string3 = this.t_br.readLine()) != null && string3.length() != 0) {
            }
            if (string2 == null || !string2.startsWith("HTTP/1.0 200")) {
                throw new CVSException("M11");
            }
        }
        catch (CVSException cVSException) {
            throw cVSException;
        }
        catch (IOException iOException) {
            if (this.t_br == null) {
                throw new CVSException("M10");
            }
            throw new CVSException("M11");
        }
        catch (Exception exception) {
            throw new CVSException("M11");
        }
    }

    private boolean isTrustHost(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.sTrustedHosts;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (!string.equals(string3.trim())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void receiveData() throws CVSException {
        this.logger.info((Object)"== Reading payment server response ==");
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            int n;
            this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "8859_1"));
            String string2 = null;
            string2 = this.br.readLine();
            if (string2 != null) {
                n = string2.indexOf(" ");
                if (n == -1) {
                    throw new CVSException("M21");
                }
            } else {
                throw new CVSException("M13");
            }
            String string3 = string2.substring(n + 1, n + 4);
            this.code = Integer.parseInt(string3);
            string = string + string2;
            string = string + "\r\n";
            n = 0;
            int n2 = -1;
            while ((string2 = this.br.readLine()) != null && string2.length() != 0) {
                if (string2.compareToIgnoreCase("Transfer-Encoding: chunked") == 0) {
                    n = 1;
                }
                if (string2.toLowerCase().startsWith("Content-Length".toLowerCase())) {
                    int n3 = string2.indexOf(":");
                    if (n3 == -1) {
                        throw new CVSException("M21");
                    }
                    String string4 = string2.substring(n3 + 2);
                    n2 = Integer.parseInt(string4, 10);
                }
                string = string + string2;
                string = string + "\r\n";
            }
            string = string + "\r\n";
            if (n != 0) {
                while ((string2 = this.br.readLine()) != null) {
                    int n4 = Integer.parseInt(string2, 16);
                    if (n4 == 0) {
                        string2 = this.br.readLine();
                        break;
                    }
                    char[] cArray = new char[n4];
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n4) {
                        if (!this.br.ready()) continue;
                        n5 = this.br.read(cArray, 0, n4 - n6);
                        if (n5 == -1) break;
                        n6 += n5;
                        stringBuffer.append(cArray, 0, n5);
                    }
                    if (n4 != n6) {
                        throw new Exception();
                    }
                    cArray = null;
                    this.br.readLine();
                }
            } else if (n2 > -1) {
                int n7;
                char[] cArray = new char[n2];
                int n8 = 0;
                for (n7 = 0; n7 < n2 && (n8 = this.br.read(cArray, 0, n2 - n7)) != -1; n7 += n8) {
                    stringBuffer.append(cArray, 0, n8);
                }
                if (n2 != n7) {
                    throw new Exception("Content-Length is a not equal readed size.");
                }
            } else {
                char[] cArray = new char[4096];
                int n9 = this.br.read(cArray, 0, cArray.length);
                while (n9 > 0) {
                    stringBuffer.append(cArray, 0, n9);
                    n9 = this.br.read(cArray, 0, cArray.length);
                    if (n9 != 0) continue;
                    System.err.println("cur == 0!!!");
                }
            }
            int n10 = string.length() + stringBuffer.length();
            this.logger.debug((Object)("recieve data(" + n10 + "):\n" + string + stringBuffer.toString()));
            this.message = stringBuffer.toString();
        }
        catch (CVSException cVSException) {
            throw cVSException;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new CVSException("M13");
        }
        catch (IOException iOException) {
            throw new CVSException("M13");
        }
        catch (Exception exception) {
            throw new CVSException("M21");
        }
    }

    private void sendData(String string, RequestMessage requestMessage) throws CVSException {
        boolean bl = false;
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            this.logger.debug((Object)"Send request.");
            if (string.length() == 0) {
                dataOutputStream.writeBytes(requestMessage.getMessage());
            } else {
                dataOutputStream.writeBytes(requestMessage.getMessageForProxy(string));
            }
            dataOutputStream.flush();
            bl = true;
            this.logger.debug((Object)("Send data\n" + requestMessage.getMessageForLogging()));
        }
        catch (CVSException cVSException) {
            throw cVSException;
        }
        catch (Exception exception) {
            if (bl) {
                throw new CVSException("M13");
            }
            throw new CVSException("M10");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void useHttpConnect(String string, int n, String string2, RequestMessage requestMessage) throws CVSException {
        try {
            try {
                if (string2 != null && string2.length() != 0) {
                    this.logger.debug((Object)("Use Proxy = " + string2));
                    URL uRL = new URL("http://" + string2);
                    this.socket = new Socket(uRL.getHost(), uRL.getPort());
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.sendData("http://" + string + ":" + n, requestMessage);
                } else {
                    this.socket = new Socket(string, n);
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.sendData("", requestMessage);
                }
                this.receiveData();
            }
            catch (CVSException cVSException) {
                throw cVSException;
            }
            catch (Exception exception) {
                if (string2 == null) throw new CVSException("M11");
                if (string2.length() == 0) throw new CVSException("M11");
                throw new CVSException("M12");
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.socket == null) throw throwable;
                this.socket.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (this.dos != null) {
            this.dos.close();
        }
        if (this.br != null) {
            this.br.close();
        }
        if (this.socket == null) return;
        this.socket.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void useHttpsConnect(String string, int n, String string2, RequestMessage requestMessage) throws CVSException {
        Security.addProvider((java.security.Provider)new Provider());
        try {
            try {
                Object object;
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                KeyStore keyStore = null;
                try {
                    keyStore = KeyStore.getInstance("JKS");
                    object = this.getCertFileURL();
                    keyStore.load(((URL)object).openStream(), "CVSCVS".toCharArray());
                }
                catch (Exception exception) {
                    this.logger.error((Object)("!!fail to use a certificate file: " + this.getCertFileURL() + "!!"));
                    throw new CVSException("M11");
                }
                trustManagerFactory.init(keyStore);
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                object = sSLContext.getSocketFactory();
                if (string2 != null && string2.length() != 0) {
                    this.logger.debug((Object)("Use Proxy = " + string2));
                    URL uRL = new URL("http://" + string2);
                    this.tunnel = new Socket(uRL.getHost(), uRL.getPort());
                    this.tunnel.setSoTimeout(this.timeout * 1000);
                    this.doTunnelHandshake(string, n);
                    this.socket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.tunnel, string, n, true);
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.checkCertificate();
                    this.sendData("https://" + string + ":" + n, requestMessage);
                } else {
                    this.socket = (SSLSocket)((SocketFactory)object).createSocket(string, n);
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.checkCertificate();
                    this.sendData("", requestMessage);
                }
                this.receiveData();
            }
            catch (CVSException cVSException) {
                throw cVSException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.logger.error((Object)"\tcan't create SSL Context");
                throw new CVSException("M11");
            }
            catch (Exception exception) {
                if (string2 == null) throw new CVSException("M11");
                if (string2.length() == 0) throw new CVSException("M11");
                throw new CVSException("M12");
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                if (this.tunnel == null) throw throwable;
                this.tunnel.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (this.dos != null) {
            this.dos.close();
        }
        if (this.br != null) {
            this.br.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.tunnel == null) return;
        this.tunnel.close();
        return;
    }
}

