/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.CVS.GWLib;

import Jp.BuySmart.CVS.GWLib.CVSException;
import Jp.BuySmart.CVS.GWLib.Crypto;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

class RequestMessage {
    protected static final String ENCODE_CHARSET = "UTF-8";
    protected static final String HMAC_ALGORITHM = "HmacSHA1";
    protected static final String HEADER_HMAC_ALGORITHM = "HMAC-SHA1-160";
    protected String sCommand = null;
    protected String sSecret = null;
    protected String sKeyHA1 = null;
    protected String sAcceptLanguage = null;
    public static final String ACCEPT_LANGUAGE_JA = "ja";
    public static final String ACCEPT_LANGUAGE_EN = "en";
    protected Map mapFields = null;

    private RequestMessage() {
    }

    public RequestMessage(String string, String string2, String string3, String string4, Map map) {
        this.sCommand = string;
        this.sSecret = string2;
        this.sKeyHA1 = string3;
        this.sAcceptLanguage = string4;
        this.mapFields = map;
    }

    public String getMessage() throws CVSException {
        String string = this.getMessageBody();
        String string2 = this.getMessageHeader(string);
        String string3 = this.getMessageStartLine();
        return string3 + string2 + string;
    }

    public String getMessageForProxy(String string) throws CVSException {
        String string2 = this.getMessageBody();
        String string3 = this.getMessageHeader(string2);
        String string4 = this.getMessageStartLineForProxy(string);
        return string4 + string3 + string2;
    }

    public String getMessageForLogging() throws CVSException {
        String string = this.getMessageBodyForLogging();
        String string2 = this.getMessageHeader(string);
        String string3 = this.getMessageStartLine();
        return string3 + string2 + string;
    }

    public String getPath() {
        return "/cvsgw/" + this.sCommand + "/" + this.sSecret;
    }

    protected String getMessageStartLine() {
        return "POST " + this.getPath() + " HTTP/1.0\r\n";
    }

    protected String getMessageStartLineForProxy(String string) {
        if (string == null) {
            return this.getMessageStartLine();
        }
        if (string.length() == 0) {
            return this.getMessageStartLine();
        }
        String string2 = string.endsWith("/") ? string + this.getPath().substring(1) : string + this.getPath();
        return "POST " + string2 + " HTTP/1.0\r\n";
    }

    protected String getMessageHeader(String string) throws CVSException {
        String string2 = Crypto.hmac(HMAC_ALGORITHM, this.sKeyHA1, string);
        return "Content-type: application/x-www-form-urlencoded\r\nContent-length: " + string.length() + "\r\n" + "Content-HMAC: h=" + HEADER_HMAC_ALGORITHM + "; s=" + this.sSecret + "; v=" + string2 + "\r\n" + "Accept-Language: " + this.sAcceptLanguage + "\r\n" + "\r\n";
    }

    protected String getMessageBody() throws CVSException {
        String string = "";
        try {
            String string2 = "";
            Iterator iterator = this.mapFields.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)this.mapFields.get(string3);
                if (string4 == null) {
                    string4 = "";
                }
                string = string + string2 + URLEncoder.encode(string3, ENCODE_CHARSET) + "=" + URLEncoder.encode(string4, ENCODE_CHARSET);
                string2 = "&";
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CVSException("M46");
        }
        return string;
    }

    protected String getMessageBodyForLogging() throws CVSException {
        String string = "";
        try {
            String string2 = "";
            Iterator iterator = this.mapFields.keySet().iterator();
            while (iterator.hasNext()) {
                int n;
                String string3 = (String)iterator.next();
                String string4 = (String)this.mapFields.get(string3);
                if (string4 == null) {
                    string4 = "";
                }
                if (string3.toLowerCase().equals("tel-no")) {
                    string4 = "***-****-****";
                } else if (string3.toLowerCase().equals("mail-addr") && (n = string4.indexOf(64)) > 0) {
                    string4 = "****" + string4.substring(n);
                }
                string = string + string2 + URLEncoder.encode(string3, ENCODE_CHARSET) + "=" + URLEncoder.encode(string4, ENCODE_CHARSET);
                string2 = "&";
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CVSException("M46");
        }
        return string;
    }

    public String getCommand() {
        return this.sCommand;
    }

    public Map getFields() {
        return this.mapFields;
    }

    public String getSecret() {
        return this.sSecret;
    }

    public String getAcceptLanguage() {
        return this.sAcceptLanguage;
    }

    public String getKeyHA1() {
        return this.sKeyHA1;
    }
}

