/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.TTCColumn;

public abstract class TTCDataSet {
    protected TTCColumn[] columns;
    protected int depth;
    protected int marshaledRows;
    protected int unmarshaledRows;
    protected int unmarshaledCols;

    protected TTCDataSet(TTCColumn[] tTCColumnArray, int n) {
        this.columns = tTCColumnArray != null ? tTCColumnArray : new TTCColumn[]{};
        this.depth = n;
    }

    public void incrementUnmarshaledcols() {
        ++this.unmarshaledCols;
    }

    public void incrementeUnmarshaledRows() {
        ++this.unmarshaledRows;
    }

    public boolean isLastCol() {
        boolean bl = this.unmarshaledCols == this.columns.length - 1;
        return bl;
    }

    protected abstract void marshalRow() throws SQLException, IOException;

    protected void marshalTypes() throws IOException, SQLException {
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].marshalType();
            ++n;
        }
    }

    protected abstract boolean next() throws SQLException, IOException;

    protected int numberOfColumns() {
        return this.columns.length;
    }

    protected void print(int n, int n2, int n3) {
        OracleLog.print(this, n, n2, n3, "   ---- Enter: TTCDataSet.print --- ");
        OracleLog.print(this, n, n2, n3, "     +++ Beginning of Columns Info +++++++ ");
        OracleLog.print(this, n, n2, n3, "         columns.length = " + this.columns.length);
        int n4 = 0;
        while (n4 < this.columns.length) {
            OracleLog.print(this, n, n2, n3, "Column # " + n4);
            this.columns[n4].print(n, n2, n3);
            ++n4;
        }
        OracleLog.print(this, n, n2, n3, "     +++ End of Columns Info +++++++ ");
        OracleLog.print(this, n, n2, n3, "     TTCDataSet.depth          =" + this.depth);
        OracleLog.print(this, n, n2, n3, "     TTCDataSet.marshaledRows  =" + this.marshaledRows);
        OracleLog.print(this, n, n2, n3, "     TTCDataSet.unmarshaledRows=" + this.unmarshaledRows);
        OracleLog.print(this, n, n2, n3, "   ---- Exit: TTCDataSet.print --- ");
    }

    protected void processIndicator() throws IOException, SQLException {
    }

    protected abstract boolean unmarshalRow() throws SQLException, IOException;

    protected boolean unmarshalRow(int n, int n2) throws SQLException, IOException {
        return false;
    }
}

