/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FooterRecord
extends Record {
    public static final short sid = 21;
    private byte field_1_footer_len;
    private byte field_2_unicode_flag;
    private String field_3_footer;

    public FooterRecord() {
    }

    public FooterRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FooterRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 21) {
            throw new RecordFormatException("NOT A FooterRECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        if (size > 0) {
            this.field_1_footer_len = data[0 + offset];
            this.field_2_unicode_flag = data[2 + offset];
            this.field_3_footer = this.isMultibyte() ? StringUtil.getFromUnicodeLE(data, 3 + offset, LittleEndian.ubyteToInt(this.field_1_footer_len)) : new String(data, 3 + offset, LittleEndian.ubyteToInt(this.field_1_footer_len));
        }
    }

    public boolean isMultibyte() {
        return (this.field_2_unicode_flag & 0xFF) == 1;
    }

    public void setFooterLength(byte len) {
        this.field_1_footer_len = len;
    }

    public void setFooter(String footer) {
        this.field_3_footer = footer;
        this.field_2_unicode_flag = (byte)(StringUtil.hasMultibyte(this.field_3_footer) ? 1 : 0);
    }

    public short getFooterLength() {
        return (short)(0xFF & this.field_1_footer_len);
    }

    public String getFooter() {
        return this.field_3_footer;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FOOTER]\n");
        buffer.append("    .footerlen      = ").append(Integer.toHexString(this.getFooterLength())).append("\n");
        buffer.append("    .footer         = ").append(this.getFooter()).append("\n");
        buffer.append("[/FOOTER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int len = 4;
        if (this.getFooterLength() > 0) {
            len += 3;
        }
        short bytelen = (short)(this.isMultibyte() ? this.getFooterLength() * 2 : this.getFooterLength());
        LittleEndian.putShort(data, 0 + offset, (short)21);
        LittleEndian.putShort(data, 2 + offset, (short)(len - 4 + bytelen));
        if (this.getFooterLength() > 0) {
            data[4 + offset] = (byte)this.getFooterLength();
            data[6 + offset] = this.field_2_unicode_flag;
            if (this.isMultibyte()) {
                StringUtil.putUnicodeLE(this.getFooter(), data, 7 + offset);
            } else {
                StringUtil.putCompressedUnicode(this.getFooter(), data, 7 + offset);
            }
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.getFooterLength() > 0) {
            retval += 3;
        }
        return this.isMultibyte() ? retval + this.getFooterLength() * 2 : retval + this.getFooterLength();
    }

    public short getSid() {
        return 21;
    }

    public Object clone() {
        FooterRecord rec = new FooterRecord();
        rec.field_1_footer_len = this.field_1_footer_len;
        rec.field_2_unicode_flag = this.field_2_unicode_flag;
        rec.field_3_footer = this.field_3_footer;
        return rec;
    }
}

