/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.UnicodeString;

class SSTRecordSizeCalculator {
    private UnicodeString unistr = null;
    private int stringReminant = 0;
    private int unipos = 0;
    private boolean isRemainingString = false;
    private int totalBytesWritten = 0;
    private boolean finished = false;
    private boolean firstRecord = true;
    private int totalWritten = 0;
    private int recordSize = 0;
    private List recordLengths = new ArrayList();
    private int pos = 0;
    private Map strings;

    public SSTRecordSizeCalculator(Map strings) {
        this.strings = strings;
    }

    private boolean canFitStringInRecord(int recordLength) {
        return recordLength + 3 < 8228;
    }

    public int getRecordSize() {
        int continueSize = 12;
        int recordSize = 0;
        for (int i = 0; i < this.strings.size(); ++i) {
            Integer intunipos = new Integer(i);
            UnicodeString unistr = (UnicodeString)this.strings.get(intunipos);
            int stringLength = unistr.getRecordSize();
            if (continueSize + stringLength <= 8228) {
                if (i >= this.strings.size() - 1 || this.canFitStringInRecord(continueSize += stringLength)) continue;
                this.recordLengths.add(new Integer(continueSize));
                recordSize += continueSize;
                continueSize = 4;
                continue;
            }
            int stringRemainder = stringLength;
            while (stringRemainder != 0) {
                if (continueSize + stringRemainder > 8228) {
                    int bytesWritten = Math.min(8228 - continueSize, stringRemainder);
                    bytesWritten = unistr.maxBrokenLength(bytesWritten);
                    stringRemainder -= bytesWritten;
                    this.recordLengths.add(new Integer(continueSize += bytesWritten));
                    recordSize += continueSize;
                    continueSize = 4;
                    ++stringRemainder;
                    continue;
                }
                stringRemainder = 0;
                if (i >= this.strings.size() - 1 || this.canFitStringInRecord(continueSize += stringRemainder)) continue;
                this.recordLengths.add(new Integer(continueSize));
                recordSize += continueSize;
                continueSize = 4;
            }
        }
        this.recordLengths.add(new Integer(continueSize));
        return recordSize += continueSize;
    }

    public List getRecordLengths() {
        return this.recordLengths;
    }
}

