/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.GroupMarkerSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.UnknownRecord;

public abstract class SubRecord
extends Record {
    public SubRecord() {
    }

    public SubRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SubRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public static Record createSubRecord(short subRecordSid, short size, byte[] data, int offset) {
        Record r = null;
        short adjustedSize = size;
        if (size < 0) {
            adjustedSize = 0;
        } else if (offset + size > data.length && (adjustedSize = (short)(data.length - offset)) > 4) {
            adjustedSize = (short)(adjustedSize - 4);
        }
        switch (subRecordSid) {
            case 21: {
                r = new CommonObjectDataSubRecord(subRecordSid, adjustedSize, data, offset);
                break;
            }
            case 6: {
                r = new GroupMarkerSubRecord(subRecordSid, adjustedSize, data, offset);
                break;
            }
            case 0: {
                r = new EndSubRecord(subRecordSid, adjustedSize, data, offset);
                break;
            }
            default: {
                r = new UnknownRecord(subRecordSid, adjustedSize, data, offset);
            }
        }
        return r;
    }
}

