/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;

public class ValueRecordsAggregate
extends Record {
    public static final short sid = -1000;
    int firstcell = -1;
    int lastcell = -1;
    TreeMap records = null;
    public final RowComparator compareRow = new RowComparator();

    public ValueRecordsAggregate() {
        this.records = new TreeMap();
    }

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface o = this.records.put(cell, cell);
        if (cell.getColumn() < this.firstcell || this.firstcell == -1) {
            this.firstcell = cell.getColumn();
        }
        if (cell.getColumn() > this.lastcell || this.lastcell == -1) {
            this.lastcell = cell.getColumn();
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        this.records.remove(cell);
    }

    public int getPhysicalNumberOfCells() {
        return this.records.size();
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public int construct(int offset, List records) {
        Record rec;
        int k = 0;
        FormulaRecordAggregate lastFormulaAggregate = null;
        for (k = offset; k < records.size() && ((rec = (Record)records.get(k)) instanceof StringRecord || rec.isInValueSection() || rec instanceof UnknownRecord); ++k) {
            if (rec instanceof FormulaRecord) {
                lastFormulaAggregate = new FormulaRecordAggregate((FormulaRecord)rec, null);
                this.insertCell(lastFormulaAggregate);
                continue;
            }
            if (rec instanceof StringRecord) {
                lastFormulaAggregate.setStringRecord((StringRecord)rec);
                continue;
            }
            if (rec instanceof SharedFormulaRecord) {
                lastFormulaAggregate.setSharedFormulaRecord((SharedFormulaRecord)rec);
                continue;
            }
            if (!rec.isValue()) continue;
            this.insertCell((CellValueRecordInterface)((Object)rec));
        }
        return k;
    }

    public int serialize(int offset, byte[] data) {
        throw new RuntimeException("This method shouldnt be called. ValueRecordsAggregate.serializeCellRow() should be called from RowRecordsAggregate.");
    }

    public int getRowCellBlockSize(int startRow, int endRow) {
        CellValueRecordInterface cell;
        int row;
        RowCellIterator itr = new RowCellIterator(startRow, endRow);
        int size = 0;
        while (itr.hasNext() && (row = (cell = (CellValueRecordInterface)itr.next()).getRow()) <= endRow) {
            if (row < startRow || row > endRow) continue;
            size += ((Record)((Object)cell)).getRecordSize();
        }
        return size;
    }

    public boolean rowHasCells(int row) {
        this.compareRow.setRow(row);
        return this.records.containsKey(this.compareRow);
    }

    public int serializeCellRow(int row, int offset, byte[] data) {
        CellValueRecordInterface cell;
        RowCellIterator itr = new RowCellIterator(row, row);
        int pos = offset;
        while (itr.hasNext() && (cell = (CellValueRecordInterface)itr.next()).getRow() == row) {
            pos += ((Record)((Object)cell)).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        int size = 0;
        Iterator irecs = this.records.values().iterator();
        while (irecs.hasNext()) {
            size += ((Record)irecs.next()).getRecordSize();
        }
        return size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }

    public Object clone() {
        ValueRecordsAggregate rec = new ValueRecordsAggregate();
        Iterator valIter = this.getIterator();
        while (valIter.hasNext()) {
            CellValueRecordInterface val = (CellValueRecordInterface)((CellValueRecordInterface)valIter.next()).clone();
            rec.insertCell(val);
        }
        return rec;
    }

    private class RowCellIterator
    implements Iterator {
        private int startRow;
        private int endRow;
        private Iterator internalIterator;
        private CellValueRecordInterface atCell;
        private RowCellComparator rowCellCompare;

        public RowCellIterator(int startRow, int endRow) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.rowCellCompare = new RowCellComparator();
            this.rowCellCompare.setRow(startRow);
        }

        public boolean hasNext() {
            if (this.internalIterator == null) {
                this.internalIterator = ValueRecordsAggregate.this.records.tailMap(this.rowCellCompare).values().iterator();
            }
            if (this.internalIterator.hasNext()) {
                this.atCell = (CellValueRecordInterface)this.internalIterator.next();
                return this.atCell.getRow() <= this.endRow;
            }
            return false;
        }

        public Object next() {
            return this.atCell;
        }

        public void remove() {
        }

        public class RowCellComparator
        extends RowComparator {
            public int compareTo(Object obj) {
                CellValueRecordInterface cell = (CellValueRecordInterface)obj;
                if (this.getRow() == cell.getRow() && cell.getColumn() == 0) {
                    return 0;
                }
                if (this.getRow() < cell.getRow()) {
                    return -1;
                }
                if (this.getRow() > cell.getRow()) {
                    return 1;
                }
                if (cell.getColumn() > 0) {
                    return -1;
                }
                if (cell.getColumn() < 0) {
                    return 1;
                }
                return -1;
            }
        }
    }

    private class RowComparator
    implements CellValueRecordInterface,
    Comparable {
        private int row;

        private RowComparator() {
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int compareTo(Object obj) {
            CellValueRecordInterface cell = (CellValueRecordInterface)obj;
            if (this.row == cell.getRow()) {
                return 0;
            }
            if (this.row < cell.getRow()) {
                return -1;
            }
            if (this.row > cell.getRow()) {
                return 1;
            }
            return -1;
        }

        public int getRow() {
            return this.row;
        }

        public short getColumn() {
            return 0;
        }

        public void setColumn(short col) {
        }

        public void setXFIndex(short xf) {
        }

        public short getXFIndex() {
            return 0;
        }

        public boolean isBefore(CellValueRecordInterface i) {
            return false;
        }

        public boolean isAfter(CellValueRecordInterface i) {
            return false;
        }

        public boolean isEqual(CellValueRecordInterface i) {
            return false;
        }

        public Object clone() {
            return null;
        }
    }
}

