/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.datetime;

import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class DateFormatSymbolsTag
extends TagSupport {
    private int scope = 1;
    private String localeRef = null;
    private boolean locale_flag = false;
    private String baseName = null;
    private ResourceBundle bundle;
    private DateFormatSymbols dateFormatSymbols;

    public void setScope(String scope) {
        if (scope.toLowerCase().equals("application")) {
            this.scope = 4;
        } else if (scope.toLowerCase().equals("session")) {
            this.scope = 3;
        } else if (scope.toLowerCase().equals("request")) {
            this.scope = 2;
        } else if (scope.toLowerCase().equals("page")) {
            this.scope = 1;
        }
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public void setLocale(boolean locale) {
        this.locale_flag = locale;
    }

    public void setLocaleRef(String localeRef) {
        this.localeRef = localeRef;
    }

    public int doStartTag() throws JspException {
        Locale locale = null;
        if (this.localeRef != null) {
            locale = (Locale)this.pageContext.findAttribute(this.localeRef);
        } else if (this.locale_flag) {
            locale = this.pageContext.getRequest().getLocale();
        } else {
            this.dateFormatSymbols = new DateFormatSymbols();
        }
        this.findBundle(locale);
        this.buildDateFormatSymbols(locale);
        if (this.getId() != null) {
            this.pageContext.setAttribute(this.getId(), (Object)this.dateFormatSymbols, this.scope);
        }
        return 0;
    }

    public void release() {
        super.release();
        this.scope = 1;
        this.localeRef = null;
        this.locale_flag = false;
        this.baseName = null;
    }

    private void buildDateFormatSymbols(Locale locale) {
        int i;
        this.dateFormatSymbols = locale != null ? new DateFormatSymbols(locale) : new DateFormatSymbols();
        try {
            String customAmPm = this.bundle.getString("ampm");
            if ("true".equals(customAmPm)) {
                String[] ampm = new String[2];
                i = 0;
                while (i < 2) {
                    ampm[i] = this.bundle.getString("ampm" + i);
                    ++i;
                }
                this.dateFormatSymbols.setAmPmStrings(ampm);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String customEras = this.bundle.getString("eras");
            if ("true".equals(customEras)) {
                String[] eras = new String[2];
                i = 0;
                while (i < 2) {
                    eras[i] = this.bundle.getString("eras" + i);
                    ++i;
                }
                this.dateFormatSymbols.setEras(eras);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String customShortMonth = this.bundle.getString("shortmonth");
            if ("true".equals(customShortMonth)) {
                String[] shortmonth = new String[12];
                i = 0;
                while (i < 12) {
                    shortmonth[i] = this.bundle.getString("shortmonth" + i);
                    ++i;
                }
                this.dateFormatSymbols.setShortMonths(shortmonth);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String customMonth = this.bundle.getString("month");
            if ("true".equals(customMonth)) {
                String[] month = new String[12];
                i = 0;
                while (i < 12) {
                    month[i] = this.bundle.getString("month" + i);
                    ++i;
                }
                this.dateFormatSymbols.setMonths(month);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String customWeekdays = this.bundle.getString("weekdays");
            if ("true".equals(customWeekdays)) {
                String[] weekdays = new String[7];
                i = 0;
                while (i < 7) {
                    weekdays[i] = this.bundle.getString("weekdays" + i);
                    ++i;
                }
                this.dateFormatSymbols.setWeekdays(weekdays);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            String customShortWeekdays = this.bundle.getString("shortweekdays");
            if ("true".equals(customShortWeekdays)) {
                String[] shortweekdays = new String[7];
                i = 0;
                while (i < 7) {
                    shortweekdays[i] = this.bundle.getString("shortweekdays" + i);
                    ++i;
                }
                this.dateFormatSymbols.setShortWeekdays(shortweekdays);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void findBundle(Locale locale) {
        if (locale != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.bundle = ResourceBundle.getBundle(this.baseName, locale, cl);
        } else {
            this.bundle = ResourceBundle.getBundle(this.baseName);
        }
    }
}

