/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;

public class ParseTag
extends BodyTagSupport {
    private boolean locale_flag = false;
    private String pattern = null;
    private String patternid = null;
    private String timeZone_string;
    private String localeRef = null;
    private TimeZone timeZone = null;
    private Date date = null;

    public final int doStartTag() throws JspException {
        return 2;
    }

    public final int doAfterBody() throws JspException {
        SimpleDateFormat sdf;
        Object attr;
        BodyContent body = this.getBodyContent();
        String s = body.getString().trim();
        body.clearBody();
        String pat = this.pattern;
        if (pat == null && this.patternid != null && (attr = ((TagSupport)this).pageContext.findAttribute(this.patternid)) != null) {
            pat = attr.toString();
        }
        if (pat == null) {
            sdf = new SimpleDateFormat();
            pat = sdf.toPattern();
        }
        if (this.localeRef != null) {
            Locale locale = (Locale)((TagSupport)this).pageContext.findAttribute(this.localeRef);
            if (locale == null) {
                throw new JspException("datetime parse tag could not find locale for localeRef \"" + this.localeRef + "\".");
            }
            sdf = new SimpleDateFormat(pat, locale);
        } else {
            sdf = this.locale_flag ? new SimpleDateFormat(pat, ((TagSupport)this).pageContext.getRequest().getLocale()) : new SimpleDateFormat(pat);
        }
        if (this.timeZone_string != null) {
            this.timeZone = (TimeZone)((TagSupport)this).pageContext.getAttribute(this.timeZone_string, 3);
            if (this.timeZone == null) {
                throw new JspTagException("Datetime parse tag timeZone script variable \"" + this.timeZone_string + " \" does not exist");
            }
            sdf.setTimeZone(this.timeZone);
        }
        try {
            this.date = null;
            this.date = sdf.parse(s);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return 0;
    }

    public final int doEndTag() throws JspException {
        long time = 0L;
        if (this.date != null) {
            time = this.date.getTime();
        }
        try {
            ((TagSupport)this).pageContext.getOut().write("" + time);
        }
        catch (Exception e) {
            throw new JspException("IO Error: " + e.getMessage());
        }
        return 6;
    }

    public final void setLocale(boolean flag) {
        this.locale_flag = flag;
    }

    public final void setTimeZone(String tz) {
        this.timeZone_string = tz;
    }

    public final void setPattern(String str) {
        this.pattern = str;
    }

    public final void setPatternId(String str) {
        this.patternid = str;
    }

    public void setLocaleRef(String value) {
        this.localeRef = value;
    }
}

