/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.datetime;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;

public class TimeZonesTag
extends BodyTagSupport {
    private boolean locale_flag = false;
    private String localeRef = null;
    private String style_string = "SHORT";
    private int style = 0;
    private String[] timeZones = null;
    private TimeZone timeZone = null;
    private int zone_num = 0;

    public final int doStartTag() throws JspException {
        this.zone_num = 0;
        if (this.style_string == null || this.style_string.equals("SHORT")) {
            this.style = 0;
        } else if (this.style_string.equals("LONG")) {
            this.style = 1;
        } else {
            throw new JspTagException("Datetime tag timeZones style attribute must be set to either SHORT or LONG");
        }
        this.timeZones = TimeZone.getAvailableIDs();
        this.timeZone = TimeZone.getTimeZone(this.timeZones[this.zone_num]);
        if (this.timeZone == null) {
            return 0;
        }
        ((TagSupport)this).pageContext.setAttribute(((TagSupport)this).id, (Object)this, 1);
        return 2;
    }

    public final int doAfterBody() throws JspException {
        ++this.zone_num;
        if (this.zone_num >= this.timeZones.length) {
            return 0;
        }
        this.timeZone = TimeZone.getTimeZone(this.timeZones[this.zone_num]);
        if (this.timeZone == null) {
            return 0;
        }
        return 2;
    }

    public final int doEndTag() throws JspException {
        ((TagSupport)this).pageContext.removeAttribute(((TagSupport)this).id, 1);
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
        }
        catch (IOException e) {
            throw new JspException("IO Error: " + e.getMessage());
        }
        return 6;
    }

    public final void setLocale(boolean flag) {
        this.locale_flag = flag;
    }

    public void setLocaleRef(String value) {
        this.localeRef = value;
    }

    public final void setStyle(String str) {
        this.style_string = str;
    }

    public final String getDisplayName() throws JspException {
        String dn = null;
        Date now = new Date();
        boolean daylight = false;
        if (this.timeZone.useDaylightTime()) {
            daylight = this.timeZone.inDaylightTime(now);
        }
        if (this.localeRef != null) {
            Locale locale = (Locale)((TagSupport)this).pageContext.findAttribute(this.localeRef);
            if (locale == null) {
                throw new JspException("datetime amPms tag could not find locale for localeRef \"" + this.localeRef + "\".");
            }
            dn = this.timeZone.getDisplayName(daylight, this.style, locale);
        } else {
            dn = this.locale_flag ? this.timeZone.getDisplayName(daylight, this.style, ((TagSupport)this).pageContext.getRequest().getLocale()) : this.timeZone.getDisplayName(daylight, this.style);
        }
        if (dn == null) {
            dn = "";
        }
        return dn;
    }

    public final String getZoneId() {
        return this.timeZone.getID();
    }
}

