/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import org.apache.taglibs.i18n.FormatTagSupport;

public class FormatNumberTag
extends FormatTagSupport {
    protected static final String _tagname = "i18n:formatNumber";
    private NumberFormat format;
    private String pattern;

    public void release() {
        super.release();
        this.format = null;
        this.pattern = null;
    }

    public Format getFormat() {
        if (this.format == null) {
            String pattern = this.getPattern();
            if (pattern != null) {
                this.format = this.getPatternFormat(pattern);
            }
            if (pattern == null) {
                this.format = this.getNumberFormat();
            }
        }
        return this.format;
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    protected NumberFormat getPatternFormat(String pattern) {
        return new DecimalFormat(pattern, new DecimalFormatSymbols(this.getLocale()));
    }

    protected NumberFormat getNumberFormat() {
        return NumberFormat.getInstance(this.getLocale());
    }
}

