/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.input;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.input.Util;

public class Select
extends TagSupport {
    private String name;
    private String dVal;
    private String[] dValArray;
    private Map attributes;
    private Map options;
    private String attributesText;
    private String beanId;
    private boolean multiple;
    private String size;
    private List optionLabels;
    private List optionValues;
    private HashMap chosen;

    public int doStartTag() throws JspException {
        try {
            String[] selected;
            String[] beanValues;
            if (this.name == null || this.name.equals("")) {
                throw new JspTagException("invalid null or empty 'name'");
            }
            String beanId = this.beanId;
            if (beanId == null) {
                beanId = Util.defaultFormBeanId((Tag)this);
            } else if (beanId.length() == 0) {
                beanId = null;
            }
            ServletRequest req = this.pageContext.getRequest();
            JspWriter out = this.pageContext.getOut();
            out.print("<select name=\"" + Util.quote(this.name) + "\" ");
            Util.printAttributes(out, this.attributes);
            if (this.attributesText != null) {
                out.print(this.attributesText + " ");
            }
            if (this.multiple) {
                out.print("multiple=\"true\" ");
            }
            if (this.size != null) {
                out.print("size=\"" + Util.quote(this.size) + "\" ");
            }
            out.println(">");
            String[] stringArray = beanValues = beanId != null ? Util.beanPropertyValues(this.pageContext.findAttribute(beanId), this.name) : null;
            if (beanValues != null) {
                selected = beanValues;
            } else {
                selected = req.getParameterValues(this.name);
                if (selected == null) {
                    if (this.dValArray != null && this.dVal != null) {
                        selected = new String[this.dValArray.length + 1];
                        selected[0] = this.dVal;
                        System.arraycopy(this.dValArray, 0, selected, 1, this.dValArray.length);
                    } else if (this.dValArray != null) {
                        selected = this.dValArray;
                    } else if (this.dVal != null) {
                        selected = new String[]{this.dVal};
                    }
                }
            }
            if (!(selected == null || selected.length <= 1 || this.attributes != null && this.attributes.containsKey("multiple") || this.multiple)) {
                selected = null;
            }
            this.chosen = new HashMap();
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    if (selected[i] != null) {
                        this.chosen.put(selected[i], null);
                    }
                    ++i;
                }
            }
            if (this.optionLabels != null) {
                int n = this.optionLabels.size();
                int i = 0;
                while (i < n) {
                    Object oKey = this.optionLabels.get(i);
                    Object oVal = this.options != null ? this.options.get(oKey) : (this.optionValues != null ? this.optionValues.get(i) : oKey);
                    this.outputOption(out, oKey, oVal);
                    ++i;
                }
            } else if (this.options != null) {
                Iterator i = this.options.keySet().iterator();
                while (i.hasNext()) {
                    Object oKey = i.next();
                    Object oVal = this.options.get(oKey);
                    this.outputOption(out, oKey, oVal);
                }
            }
        }
        catch (Exception ex) {
            throw new JspTagException(ex.getMessage());
        }
        return 1;
    }

    private void outputOption(JspWriter out, Object oKey, Object oVal) throws IOException {
        String value;
        String key = oKey.toString();
        String string = value = oVal != null ? oVal.toString() : null;
        if (value == null) {
            value = key;
        }
        out.print("<option");
        if (!value.equals(key)) {
            out.print(" value=\"" + Util.quote(value) + "\"");
        }
        if (this.chosen.containsKey(value)) {
            out.print(" selected=\"true\"");
        }
        out.print(">");
        out.print(Util.quote(key));
        out.println("</option>");
    }

    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print("</select>");
        }
        catch (Exception ex) {
            throw new JspTagException(ex.getMessage());
        }
        return 6;
    }

    public void setName(String x) {
        this.name = x;
    }

    public void setAttributes(Map x) {
        this.attributes = x;
    }

    public void setAttributesText(String x) {
        this.attributesText = x;
    }

    public void setBean(String x) {
        this.beanId = x;
    }

    public void setMultiple(boolean x) {
        this.multiple = x;
    }

    public void setSize(String x) {
        this.size = x;
    }

    public void setDefault(String x) {
        this.dVal = x;
    }

    public void setDefaults(String[] x) {
        this.dValArray = x;
    }

    public void setDefaults(Map x) {
        this.dValArray = new String[x.size()];
        Iterator it = x.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            this.dValArray[i++] = it.next().toString();
        }
    }

    public void setDefaults(Collection c) {
        this.dValArray = new String[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.dValArray[i++] = it.next().toString();
        }
    }

    public void setOptions(Map x) {
        this.options = x;
    }

    public void setOptionLabels(List x) {
        this.optionLabels = x;
    }

    public void setOptionValues(List x) {
        this.optionValues = x;
    }

    public HashMap getChosen() {
        return this.chosen;
    }

    public String getName() {
        return this.name;
    }

    public String getDefault() {
        return this.dVal;
    }

    public String getBean() {
        return this.beanId;
    }

    public String getAttributesText() {
        return this.attributesText;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String[] getDefaults() {
        return this.dValArray;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public List getOptionLabels() {
        return this.optionLabels;
    }

    public List getOptionValues() {
        return this.optionValues;
    }

    public Map getOptions() {
        return this.options;
    }

    public String getSize() {
        return this.size;
    }
}

