/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.connection.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import jp.veritrans.tercerog.mdk.connection.proxy.ProxySocket;
import jp.veritrans.tercerog.mdk.connection.ssl.SSLConfigurator;

public class SSLSocketUtils {
    public SSLSocket createSSLSocket(String string, int n, SSLConfigurator sSLConfigurator) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException, UnknownHostException, Exception {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory(sSLConfigurator);
        ProxySocket proxySocket = new ProxySocket(2);
        Socket socket = proxySocket.getProxySocket();
        SSLSocket sSLSocket = null;
        sSLSocket = socket != null ? (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, false) : (SSLSocket)sSLSocketFactory.createSocket(string, n);
        int n2 = sSLConfigurator.getTimeoutSec();
        sSLSocket.setSoTimeout(n2);
        if (sSLSocket.isClosed()) {
            sSLSocket.startHandshake();
        }
        return sSLSocket;
    }

    public SSLSocketFactory getSSLSocketFactory(SSLConfigurator sSLConfigurator) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, CertificateException, FileNotFoundException, UnrecoverableKeyException, IOException {
        String string = sSLConfigurator.getKeystorePath();
        String string2 = sSLConfigurator.getKeystorePass();
        String string3 = sSLConfigurator.getKeystoreType();
        String string4 = sSLConfigurator.getKeystoreAlgorithm();
        KeyManager[] keyManagerArray = null;
        if (string != null && string2 != null && string3 != null && string4 != null) {
            keyManagerArray = this.getKeyManager(string, string2, string3, string4);
        }
        String string5 = sSLConfigurator.getTruststorePath();
        String string6 = sSLConfigurator.getTruststorePass();
        String string7 = sSLConfigurator.getTruststoreType();
        String string8 = sSLConfigurator.getTruststoreAlgorithm();
        TrustManager[] trustManagerArray = this.getTrustManager(string5, string6, string7, string8);
        String string9 = sSLConfigurator.getProtocol();
        SSLContext sSLContext = SSLContext.getInstance(string9);
        SecureRandom secureRandom = new SecureRandom();
        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyManager[] getKeyManager(String string, String string2, String string3, String string4) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyManager[] keyManagerArray;
        FileInputStream fileInputStream = null;
        try {
            try {
                KeyManager[] keyManagerArray2;
                fileInputStream = new FileInputStream(string);
                KeyStore keyStore = KeyStore.getInstance(string3);
                char[] cArray = string2.toCharArray();
                keyStore.load(fileInputStream, cArray);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string4);
                keyManagerFactory.init(keyStore, cArray);
                keyManagerArray = keyManagerArray2 = keyManagerFactory.getKeyManagers();
                Object var12_17 = null;
                if (fileInputStream == null) return keyManagerArray;
            }
            catch (KeyStoreException keyStoreException) {
                throw keyStoreException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (CertificateException certificateException) {
                throw certificateException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw unrecoverableKeyException;
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return keyManagerArray;
        }
        fileInputStream.close();
        return keyManagerArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TrustManager[] getTrustManager(String string, String string2, String string3, String string4) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        TrustManager[] trustManagerArray;
        FileInputStream fileInputStream = null;
        try {
            try {
                TrustManager[] trustManagerArray2;
                fileInputStream = new FileInputStream(string);
                KeyStore keyStore = KeyStore.getInstance(string3);
                char[] cArray = string2.toCharArray();
                keyStore.load(fileInputStream, cArray);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string4);
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerArray2 = trustManagerFactory.getTrustManagers();
                Object var12_16 = null;
                if (fileInputStream == null) return trustManagerArray;
            }
            catch (KeyStoreException keyStoreException) {
                throw keyStoreException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (CertificateException certificateException) {
                throw certificateException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return trustManagerArray;
        }
        fileInputStream.close();
        return trustManagerArray;
    }
}

