/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.context;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import jp.veritrans.tercerog.mdk.MerchantConfig;
import jp.veritrans.tercerog.mdk.dto.IBaseDto;
import jp.veritrans.tercerog.mdk.exception.MdkLocalException;
import jp.veritrans.tercerog.mdk.util.MdkUtil;

public class MerchantContext {
    private static final String REQUEST = "RequestDto";
    private static final String RESPONSE = "ResponseDto";
    private static Set dtoNames = new HashSet();
    private IBaseDto baseDto;
    private MerchantConfig merchantConfig = null;
    private String nameAndValues = null;
    private String originalNameAndValues = null;
    private String responseDtoName = null;

    private MerchantContext() {
    }

    public MerchantContext(IBaseDto iBaseDto) throws MdkLocalException {
        this();
        if (iBaseDto == null) {
            throw new MdkLocalException("Dto object is null. ", "MA99");
        }
        String string = iBaseDto.getClass().getName();
        if (!dtoNames.contains(string)) {
            throw new MdkLocalException("Invalid instance, argument must be Dto. ", "MA99");
        }
        this.responseDtoName = string.replaceFirst(REQUEST, RESPONSE);
        this.baseDto = iBaseDto;
        this.merchantConfig = new MerchantConfig();
    }

    public IBaseDto getBaseDto() {
        return this.baseDto;
    }

    public MerchantConfig getMerchantConfig() {
        return this.merchantConfig;
    }

    public void setNameAndValues(String string) {
        this.nameAndValues = string;
    }

    public String getNameAndValues() {
        return this.nameAndValues;
    }

    public String getOriginalNameAndValues() {
        return this.originalNameAndValues;
    }

    public void setOriginalNameAndValues(String string) {
        this.originalNameAndValues = string;
    }

    public String getResponseDtoName() {
        return this.responseDtoName;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("dto");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        String string = MdkUtil.getPackageName(IBaseDto.class);
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if ("MDK_DTO_VERSION".equals(string2)) continue;
            dtoNames.add(string + "." + resourceBundle.getString(string2));
        }
    }
}

