/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.gw.utils;

import java.security.MessageDigest;

public class HashUtils {
    private static final HashUtils instance = new HashUtils();
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String DECODE_CHARSET = "utf-8";

    private HashUtils() {
    }

    public static HashUtils getInstance() {
        return instance;
    }

    public String getDigest(String[] stringArray) throws Exception {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        String string = this.getDigest(stringBuffer.toString());
        return string;
    }

    public String getDigest(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] byArray = string.getBytes(DECODE_CHARSET);
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        for (int i = 0; i < byArray2.length; ++i) {
            int n = byArray2[i];
            if (n < 0) {
                n += 256;
            }
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n, 16));
        }
        return stringBuffer.toString();
    }
}

