/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import jp.veritrans.tercerog.mdk.util.HexUtil;

public final class Hmac {
    private Mac mac = null;

    private Hmac(String string) throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(string);
    }

    private Hmac(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.mac = Mac.getInstance(string, string2);
    }

    private Hmac(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.mac = Mac.getInstance(string, provider.getName());
    }

    public static Hmac getInstance(String string) throws NoSuchAlgorithmException {
        return new Hmac(string);
    }

    public static Hmac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new Hmac(string, string2);
    }

    public static Hmac getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new Hmac(string, provider);
    }

    public void init(String string) throws InvalidKeyException {
        try {
            byte[] byArray = HexUtil.toBytes(string);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.mac.getAlgorithm());
            this.mac.init(secretKeySpec);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(numberFormatException.getMessage());
        }
    }

    public void update(byte by) {
        this.mac.update(by);
    }

    public void update(byte[] byArray) {
        this.mac.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
    }

    public String doFinal() {
        return HexUtil.toString(this.mac.doFinal());
    }

    public String doFinal(byte[] byArray) {
        return HexUtil.toString(this.mac.doFinal(byArray));
    }

    public void reset() {
        this.mac.reset();
    }
}

