/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sint.filters;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SISecureSessionFilter
implements Filter {
    private static Logger logger = Logger.getLogger((Class)SISecureSessionFilter.class);
    private ResourceBundle configure;
    private boolean disabled = false;
    private String anotherRemoteAddressHeader = null;
    private static final String SI_SESSION_INFO_ID = "SISessionInfoID";
    private static final String REMOTE_ADDR_INSTEAD_OF = "remote_addr_instead_of";
    private List excludeExtensionsList = new ArrayList();
    private static final int OCTET = 8;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug((Object)"init: start");
        String resourceName = filterConfig.getInitParameter("Configures");
        try {
            this.configure = ResourceBundle.getBundle(resourceName);
            logger.info((Object)"Configuration resource has loaded.");
            Enumeration<String> en = this.configure.getKeys();
            while (en.hasMoreElements()) {
                String k = en.nextElement();
                String v = this.configure.getString(k);
                logger.debug((Object)(k + "=" + v));
                if (k.equals(REMOTE_ADDR_INSTEAD_OF)) {
                    this.anotherRemoteAddressHeader = v;
                }
                if (k.startsWith("useragent.docomo")) {
                    DeviceInfo.userAgentDocomo.add(v);
                }
                if (k.startsWith("useragent.au")) {
                    DeviceInfo.userAgentAu.add(v);
                }
                if (k.startsWith("useragent.softbank")) {
                    DeviceInfo.userAgentSoftbank.add(v);
                }
                if (k.startsWith("useragent.other")) {
                    DeviceInfo.userAgentOther.add(v);
                }
                if (!k.startsWith("filter.exclude_extension")) continue;
                this.excludeExtensionsList.add(v);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            logger.warn((Object)("Missing configuration resource (" + resourceName + ")."));
            this.disabled = true;
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)"init: end");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.disabled) {
            throw new ServletException("DISABLED");
        }
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            String requestUri = httpRequest.getRequestURI().toLowerCase();
            boolean isNotApplicatable = false;
            for (int i = 0; i < this.excludeExtensionsList.size(); ++i) {
                String extention = (String)this.excludeExtensionsList.get(i);
                isNotApplicatable |= requestUri.endsWith(extention);
            }
            if (isNotApplicatable) {
                logger.debug((Object)"doFilter: requested url is excluded.");
                chain.doFilter(req, res);
            } else {
                logger.debug((Object)"doFilter: requested url needs a session-check.");
                this.doFilter2(req, res, chain);
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("filtering error : " + e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void doFilter2(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            boolean r;
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            SessionInfo first = this.getFirstAccessInfo(httpRequest);
            SessionInfo current = this.getCurrentAccessInfo(httpRequest);
            if (first == null) {
                first = current;
            }
            boolean hijacked = false;
            if (this.checkAlreadyHijacked()) {
                r = first.isHijacked();
                hijacked |= r;
                logger.debug((Object)("result=" + r));
            }
            if (this.checkDifferentIPArea()) {
                r = !first.isFrom().equals(current.isFrom());
                hijacked |= r;
                logger.debug((Object)("result=" + r));
            }
            if (this.checkDifferentRemoteAddr(current)) {
                r = !first.getRemoteAddr().equals(current.getRemoteAddr());
                hijacked |= r;
                logger.debug((Object)("result=" + r));
            }
            if (this.checkDifferentUserAgent(current)) {
                r = !first.getUserAgent().equals(current.getUserAgent());
                hijacked |= r;
                logger.debug((Object)("result=" + r));
            }
            if (this.checkDifferentDevice(current)) {
                r = !first.getDeviceInfo().hasSameValues(current.getDeviceInfo());
                hijacked |= r;
                logger.debug((Object)("result=" + r));
            }
            if (this.checkDifferentSubnet(current)) {
                r = !current.usesCorrectSubnet();
                hijacked |= r;
                logger.debug((Object)("result=" + r));
            }
            first.put("HIJACKED", hijacked);
            current.put("HIJACKED", hijacked);
            httpRequest.getSession(true).setAttribute(SI_SESSION_INFO_ID, (Object)first);
            if (hijacked) {
                logger.warn((Object)"A Session Hijack was detected.");
                logger.warn((Object)("first  =" + first.toString()));
                logger.warn((Object)("current=" + current.toString()));
                if (this.invalidateHijackedSession()) {
                    httpRequest.getSession(true).invalidate();
                }
                logger.warn((Object)("error-url : " + this.getForwarded(current)));
                httpRequest.getRequestDispatcher(this.getForwarded(current)).forward(req, res);
            } else {
                logger.debug((Object)("Safe Access: current=" + current.toString()));
                chain.doFilter(req, res);
            }
        }
        catch (RuntimeException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        logger.debug((Object)"destroy");
    }

    private String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        if (this.anotherRemoteAddressHeader != null) {
            remoteAddr = request.getHeader(this.anotherRemoteAddressHeader);
        }
        if (remoteAddr == null) {
            remoteAddr = "";
        }
        return remoteAddr;
    }

    private String getForwarded(SessionInfo sessionInfo) {
        return this.configure.getString("after_hijacked." + this.getDeviceName(sessionInfo));
    }

    private boolean checkAlreadyHijacked() {
        return this.getMode("mode.already_hijacked");
    }

    private boolean checkDifferentIPArea() {
        return this.getMode("mode.different_ip_area");
    }

    private boolean checkDifferentRemoteAddr(SessionInfo se) {
        return this.getMode("mode." + this.getDeviceName(se) + ".different_remote_addr");
    }

    private boolean checkDifferentUserAgent(SessionInfo se) {
        return this.getMode("mode." + this.getDeviceName(se) + ".different_user_agent");
    }

    private boolean checkDifferentDevice(SessionInfo se) {
        return this.getMode("mode." + this.getDeviceName(se) + ".different_device");
    }

    private boolean checkDifferentSubnet(SessionInfo se) {
        return this.getMode("mode." + this.getDeviceName(se) + ".different_subnet");
    }

    private String getDeviceName(SessionInfo se) {
        if (se.isDocomo()) {
            return "docomo";
        }
        if (se.isAu()) {
            return "au";
        }
        if (se.isSoftbank()) {
            return "softbank";
        }
        if (se.isOther()) {
            return "other";
        }
        return "pc";
    }

    private boolean invalidateHijackedSession() {
        return this.getMode("hijacked_session_invalidate");
    }

    private boolean getMode(String key) {
        boolean result = false;
        try {
            String v = this.configure.getString(key);
            result = v.equals("1");
        }
        catch (Exception e) {
            result = false;
        }
        if (result) {
            logger.debug((Object)("checkMode: " + key));
        }
        return result;
    }

    private DeviceInfo getDeviceInfo(HttpServletRequest request) {
        String ser;
        DeviceInfo m = new DeviceInfo();
        String userAgent = request.getHeader("user-agent");
        String dcmGuid = request.getHeader("x-dcmguid");
        String ezNo = request.getHeader("x-up-subno");
        String jphoneUid = request.getHeader("x-jphone-uid");
        String docomoUserId = request.getParameter("uid");
        if (userAgent == null) {
            userAgent = "";
        }
        if (dcmGuid == null) {
            dcmGuid = "";
        }
        if (ezNo == null) {
            ezNo = "";
        }
        if (jphoneUid == null) {
            jphoneUid = "";
        }
        if (docomoUserId == null) {
            docomoUserId = "";
        }
        m.put("user-agent", userAgent);
        m.put("x-dcmguid", dcmGuid);
        m.put("x-up-subno", ezNo);
        m.put("x-jphone-uid", jphoneUid);
        m.put("uid", docomoUserId);
        m.put("CACHE_HTTP_X_DCMGUID", "");
        m.put("CACHE_PARAM_UID", "");
        m.put("FOMA_SER", "");
        m.put("FOMA_ICC", "");
        m.put("MOVA_SER", "");
        m.put("SOFTBANK_SN", "");
        Matcher matcher = null;
        if (userAgent.indexOf("DoCoMo/2.0") >= 0) {
            matcher = Pattern.compile("(ser[a-zA-Z0-9]{15})").matcher(userAgent);
            ser = "";
            if (matcher.find()) {
                ser = matcher.group();
            }
            m.put("FOMA_SER", ser);
            matcher = Pattern.compile("(icc[a-zA-Z0-9]{20})").matcher(userAgent);
            String icc = "";
            if (matcher.find()) {
                icc = matcher.group();
            }
            m.put("FOMA_ICC", icc);
        }
        if (userAgent.indexOf("DoCoMo/1.0") >= 0) {
            matcher = Pattern.compile("(ser[a-zA-Z0-9]{11})").matcher(userAgent);
            ser = "";
            if (matcher.find()) {
                ser = matcher.group();
            }
            m.put("MOVA_SER", ser);
        }
        matcher = Pattern.compile("(SN[0-9]{15})").matcher(userAgent);
        String sn = "";
        if (matcher.find()) {
            sn = matcher.group();
        }
        m.put("SOFTBANK_SN", sn);
        return m;
    }

    private SessionInfo getFirstAccessInfo(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        return (SessionInfo)session.getAttribute(SI_SESSION_INFO_ID);
    }

    private SessionInfo getCurrentAccessInfo(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        SessionInfo info = new SessionInfo();
        info.put("SESSION_ID", session.getId());
        info.put("REMOTE_ADDR", this.getRemoteAddr(request));
        info.put("DEVICE_INFO", this.getDeviceInfo(request));
        String isFrom = "PC";
        MobileSubnet ms = this.getMobileSubnet(request);
        if (ms.isMatched()) {
            isFrom = "MOBILE";
        }
        info.put("MOBILE_SUBNET", ms);
        info.put("IS_FROM", isFrom);
        info.put("HIJACKED", false);
        return info;
    }

    private MobileSubnet getMobileSubnet(HttpServletRequest request) {
        if (this.configure == null) {
            return new MobileSubnet();
        }
        boolean matched = false;
        try {
            String accessed = this.getRemoteAddr(request);
            InetAddress addr1 = InetAddress.getByName(accessed);
            MessageFormat mf = new MessageFormat("{0}/{1}");
            Enumeration<String> en = this.configure.getKeys();
            while (en.hasMoreElements()) {
                int mask;
                Object[] o;
                InetAddress addr2;
                String key = en.nextElement();
                String val = this.configure.getString(key);
                if (!key.startsWith("mobileaddr") || !(matched = this.isMatch(addr1, addr2 = InetAddress.getByName((o = mf.parse(val))[0].toString()), mask = Integer.parseInt(o[1].toString())))) continue;
                logger.debug((Object)("Accessed IP address(" + accessed + ") MATCHED for the pattern(" + val + ")"));
                return new MobileSubnet(key, val);
            }
        }
        catch (Exception e) {
            matched = false;
            throw new IllegalArgumentException(e.getMessage());
        }
        logger.debug((Object)("matched=" + matched));
        return new MobileSubnet();
    }

    private boolean isMatch(InetAddress addr1, InetAddress addr2, int mask) {
        return this.isMatch(addr1.getAddress(), addr2.getAddress(), mask);
    }

    private boolean isMatch(byte[] addr1, byte[] addr2, int mask) {
        if (addr1.length != addr2.length || mask < 0 && mask > addr1.length * 8) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < addr1.length && mask > 0; mask -= 8, ++i) {
            int shift = 0;
            if (mask / 8 == 0) {
                shift = 8 - mask % 8;
            }
            result &= addr1[i] >> shift == addr2[i] >> shift;
        }
        return result;
    }

    public static class SessionInfo
    extends HashMap {
        private static final long serialVersionUID = 1L;
        public static final String SESSION_ID = "SESSION_ID";
        public static final String HIJACKED = "HIJACKED";
        public static final String IS_FROM = "IS_FROM";
        public static final String MOBILE_SUBNET = "MOBILE_SUBNET";
        public static final String REMOTE_ADDR = "REMOTE_ADDR";
        public static final String DEVICE_INFO = "DEVICE_INFO";
        public static final String FROM_PC = "PC";
        public static final String FROM_MOBILE = "MOBILE";

        public boolean isFirstAccess() {
            return this.isEmpty();
        }

        public boolean isHijacked() {
            Boolean b = (Boolean)this.get(HIJACKED);
            return b != null && b != false;
        }

        public boolean isDocomo() {
            return this.getDeviceInfo().isDocomo();
        }

        public boolean isAu() {
            return this.getDeviceInfo().isAu();
        }

        public boolean isSoftbank() {
            return this.getDeviceInfo().isSoftbank();
        }

        public boolean isOther() {
            return this.getDeviceInfo().isOther();
        }

        public String isFrom() {
            return this.get(IS_FROM).toString();
        }

        public String getRemoteAddr() {
            return this.get(REMOTE_ADDR).toString();
        }

        public String getUserAgent() {
            return this.getDeviceInfo().getUserAgent();
        }

        public DeviceInfo getDeviceInfo() {
            return (DeviceInfo)this.get(DEVICE_INFO);
        }

        public MobileSubnet getMobileSubnet() {
            return (MobileSubnet)this.get(MOBILE_SUBNET);
        }

        public boolean isFromPC() {
            return this.isFrom().equals(FROM_PC);
        }

        public boolean isFromMobile() {
            return this.isFrom().equals(FROM_MOBILE);
        }

        public boolean usesCorrectSubnet() {
            DeviceInfo di = this.getDeviceInfo();
            MobileSubnet ms = this.getMobileSubnet();
            logger.debug((Object)"start");
            if (di.isDocomo() && !ms.isFromDocomo()) {
                logger.debug((Object)"docomo");
                return false;
            }
            if (di.isAu() && !ms.isFromAu()) {
                logger.debug((Object)"au");
                return false;
            }
            if (di.isSoftbank() && !ms.isFromSoftbank()) {
                logger.debug((Object)"softbank");
                return false;
            }
            if (di.isOther() && !ms.isFromOther()) {
                logger.debug((Object)"other");
                return false;
            }
            if (!di.isAnyMobile() && ms.isMatched()) {
                logger.debug((Object)"pc");
                return false;
            }
            logger.debug((Object)"passed!");
            return true;
        }
    }

    public static class MobileSubnet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String matched = "";
        private String subnet = "";

        public MobileSubnet() {
        }

        public MobileSubnet(String matched, String subnet) {
            if (matched != null) {
                this.matched = matched;
            }
            if (subnet != null) {
                this.subnet = subnet;
            }
        }

        public String getMatched() {
            return this.matched;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public boolean isFromDocomo() {
            return this.getMatched().toLowerCase().indexOf("docomo") >= 0;
        }

        public boolean isFromAu() {
            return this.getMatched().toLowerCase().indexOf("au") >= 0;
        }

        public boolean isFromSoftbank() {
            return this.getMatched().toLowerCase().indexOf("softbank") >= 0;
        }

        public boolean isFromOther() {
            return this.getMatched().toLowerCase().indexOf("other") >= 0;
        }

        public boolean isMatched() {
            return !this.isNotMatched();
        }

        public boolean isNotMatched() {
            return this.getMatched().length() == 0;
        }

        public String toString() {
            if (this.isMatched()) {
                return "[matched: " + this.getSubnet() + " as " + this.getMatched() + "]";
            }
            return "[not matched]";
        }
    }

    private static class DeviceInfo
    extends HashMap {
        public static List userAgentDocomo = new ArrayList();
        public static List userAgentAu = new ArrayList();
        public static List userAgentSoftbank = new ArrayList();
        public static List userAgentOther = new ArrayList();
        private static final long serialVersionUID = 1L;
        public static final String HTTP_USER_AGENT = "user-agent";
        public static final String HTTP_X_DCMGUID = "x-dcmguid";
        public static final String HTTP_X_UP_SUBNO = "x-up-subno";
        public static final String HTTP_X_JPHONE_UID = "x-jphone-uid";
        public static final String UA_FOMA_SER = "FOMA_SER";
        public static final String UA_FOMA_ICC = "FOMA_ICC";
        public static final String UA_MOVA_SER = "MOVA_SER";
        public static final String UA_SOFTBANK_SN = "SOFTBANK_SN";
        public static final String PARAM_UID = "uid";
        public static final String CACHE_HTTP_X_DCMGUID = "CACHE_HTTP_X_DCMGUID";
        public static final String CACHE_PARAM_UID = "CACHE_PARAM_UID";

        private DeviceInfo() {
        }

        public String getUserAgent() {
            String ua = (String)this.get(HTTP_USER_AGENT);
            if (ua == null) {
                ua = "";
            }
            return ua;
        }

        private boolean userAgentIsIn(String userAgent, List list) {
            boolean result = false;
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                result |= userAgent.indexOf(itr.next().toString()) >= 0;
            }
            return result;
        }

        public boolean isDocomo() {
            return this.userAgentIsIn(this.getUserAgent(), userAgentDocomo);
        }

        public boolean isAu() {
            return this.userAgentIsIn(this.getUserAgent(), userAgentAu);
        }

        public boolean isSoftbank() {
            return this.userAgentIsIn(this.getUserAgent(), userAgentSoftbank);
        }

        public boolean isOther() {
            return this.userAgentIsIn(this.getUserAgent(), userAgentOther);
        }

        public boolean isAnyMobile() {
            return this.isDocomo() || this.isAu() || this.isSoftbank() || this.isOther();
        }

        public boolean hasSameValues(DeviceInfo that) {
            HashMap<String, String> cacheKeyMap = new HashMap<String, String>();
            cacheKeyMap.put(CACHE_HTTP_X_DCMGUID, HTTP_X_DCMGUID);
            cacheKeyMap.put(CACHE_PARAM_UID, PARAM_UID);
            Set ks1 = this.keySet();
            Set ks2 = that.keySet();
            if (((Object)ks1).equals(ks2)) {
                boolean result = true;
                ArrayList keyList = new ArrayList(ks1);
                Collections.sort(keyList);
                Iterator<Object> itr = keyList.iterator();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String firstValue = (String)this.get(key);
                    String currentValue = (String)that.get(key);
                    logger.debug((Object)("  key:" + key));
                    logger.debug((Object)("    firstValue  =" + firstValue));
                    logger.debug((Object)("    currentValue=" + currentValue));
                    if (this.hasValueBoth(firstValue, currentValue)) {
                        boolean b = firstValue.equals(currentValue);
                        result &= b;
                        logger.debug((Object)("    equals? -> " + b));
                    } else {
                        logger.debug((Object)"    (not checked)");
                    }
                    if (!cacheKeyMap.containsKey(key)) continue;
                    String origKeyName = (String)cacheKeyMap.get(key);
                    currentValue = (String)that.get(origKeyName);
                    logger.debug((Object)("    [cache]firstValue  =" + firstValue));
                    logger.debug((Object)("    [cache]currentValue=" + currentValue));
                    if (this.hasValueBoth(currentValue, firstValue)) {
                        boolean b = firstValue.equals(currentValue);
                        result &= b;
                        logger.debug((Object)("    (cache check:equals?) -> " + b));
                        continue;
                    }
                    logger.debug((Object)"    (cache not checked)");
                }
                logger.debug((Object)"------------------------------------------");
                logger.debug((Object)"parameter cache start");
                itr = cacheKeyMap.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    String cacheKey = (String)entry.getKey();
                    String origKey = (String)entry.getValue();
                    String firstVal = this.get(cacheKey).toString();
                    String currVal = that.get(origKey).toString();
                    if (!this.hasValue(currVal) || !this.isNullOrEmpty(firstVal)) continue;
                    logger.debug((Object)("--->PUT INTO THE FIRST CACHE:" + origKey + "(" + currVal + ")"));
                    this.put(cacheKey, currVal);
                }
                logger.debug((Object)"paramter cache end");
                logger.debug((Object)"------------------------------------------");
                return result;
            }
            logger.debug((Object)"KeySet before/after are not equal.");
            logger.debug((Object)("before: " + ks1));
            logger.debug((Object)("after : " + ks2));
            return false;
        }

        private boolean hasValueBoth(String s1, String s2) {
            return this.hasValue(s1) && this.hasValue(s2);
        }

        private boolean hasValue(String s) {
            return s != null && s.length() > 0;
        }

        private boolean isNullOrEmpty(String s) {
            return s == null || s.length() == 0;
        }
    }
}

