/*
 * Decompiled with CFR 0.152.
 */
package CCKK.CCBSXLib;

import CCKK.CCBSXLib.CCActTable;
import CCKK.CCBSXLib.CCComServer;
import CCKK.CCBSXLib.CCConfig;
import CCKK.CCBSXLib.CCCrypto;
import CCKK.CCBSXLib.CCDebug;
import CCKK.CCBSXLib.CCException;
import CCKK.CCBSXLib.CCMsgTable;
import CCKK.CCBSXLib.CCQueryString;
import CCKK.CCBSXLib.CCTable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class CCTransaction {
    private final String TXNVERSION = "1.0";
    private final String CC_MSTATUS = "MStatus";
    private final String CC_MERRLOC = "MErrLoc";
    private final String CC_MERRMSG = "MErrMsg";
    private final String CC_AUXMSG = "aux-msg";
    private final String CC_ACTCODE = "action-code";
    private final String CC_MSTATUS_SC = "success";
    private final String CC_MSTATUS_FH = "failure-hard";
    private final String CC_MSTATUS_FQC = "failure-q-or-cancel";
    private final String CC_MSTATUS_FQD = "failure-q-or-discard";
    private final String MDK_ERRLOC = "ccbsxlib";
    private final int CARD_DIGIT_MAX = 26;
    private final int RETRY = 2;
    private CCDebug log = null;
    private CCConfig conf = null;

    public CCTransaction(String string) {
        this.setServer(string);
    }

    public void acceptLanguage(String string) {
        this.conf.put("ACCEPT_LANG", string);
    }

    private void addTxnVersion(Hashtable hashtable) throws CCException {
        if (hashtable.containsKey("txn-version")) {
            this.debug(1, "override txn-version");
            throw new CCException(99000044);
        }
        hashtable.put("txn-version", "1.0");
    }

    private void checkCardDigit(Hashtable hashtable) throws CCException {
        String string = (String)hashtable.get("card-number");
        if (string != null && string.length() > 26) {
            throw new CCException(99000003, CCDebug.blindCardNumber(string));
        }
    }

    private void checkPendingDirectory() throws CCException {
        File file = new File(this.conf.get("PENDING_DIR"));
        if (!(file.isDirectory() && file.canWrite() && file.canRead())) {
            this.debug(1, "!!Checking a pending directory is fail. : " + file.getName() + "\n");
            throw new CCException(99000045);
        }
    }

    private void checkRequestFeild(String string, Hashtable hashtable) throws CCException {
        try {
            if (string.equals("mauthonly") || string.equals("authonly")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!hashtable.containsKey("card-number")) {
                    throw new Exception("card-number");
                }
                if (!hashtable.containsKey("card-exp")) {
                    throw new Exception("card-exp");
                }
            } else if (string.equals("mauthcapture") || string.equals("authcapture")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!hashtable.containsKey("card-number")) {
                    throw new Exception("card-number");
                }
                if (!hashtable.containsKey("card-exp")) {
                    throw new Exception("card-exp");
                }
            } else if (string.equals("postauth")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("amount")) {
                    throw new Exception("amount");
                }
            } else if (string.equals("void")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("txn-type")) {
                    throw new Exception("txn-type");
                }
            } else if (string.equals("return")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("amount")) {
                    throw new Exception("amount");
                }
            } else if (string.equals("payrequest")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!hashtable.containsKey("note")) {
                    throw new Exception("note");
                }
            } else if (string.equals("retry")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
            } else if (string.equals("card-query")) {
                if (!hashtable.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!hashtable.containsKey("passwd")) {
                    throw new Exception("passwd");
                }
            } else if (string.equals("query-orders")) {
                if (!hashtable.containsKey("start-time")) {
                    throw new Exception("start-time");
                }
                if (!hashtable.containsKey("end-time")) {
                    throw new Exception("end-time");
                }
            }
        }
        catch (Exception exception) {
            throw new CCException(99000002, exception.getMessage());
        }
    }

    private String createPendingFilename() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        return String.valueOf(this.conf.get("PENDING_DIR")) + "/" + simpleDateFormat.format(new Date()) + ".csv";
    }

    public void debug(int n, String string) {
        this.log.write(n, string);
    }

    public static String genHash(String string, String string2, String string3) {
        return CCCrypto.genHash(string, string2, string3);
    }

    public String get(String string) {
        return this.conf.get(string);
    }

    private void pending(String string, Hashtable hashtable) throws CCException {
        this.debug(9, "\t== Entering pending ==\n");
        this.debug(1, "!!Pending had occured.\n");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        String string2 = String.valueOf(simpleDateFormat.format(new Date())) + ",";
        hashtable.remove("txn-version");
        string2 = String.valueOf(string2) + string;
        string2 = String.valueOf(string2) + ",";
        Enumeration enumeration = hashtable.keys();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = String.valueOf(string2) + string3;
            string2 = String.valueOf(string2) + ",";
            string2 = string3.equals("card-number") ? String.valueOf(string2) + CCDebug.blindCardNumber((String)hashtable.get(string3)) : String.valueOf(string2) + (String)hashtable.get(string3);
            if (!enumeration.hasMoreElements()) continue;
            string2 = String.valueOf(string2) + ",";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.createPendingFilename(), true);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            bufferedWriter.close();
            this.debug(9, "\t== Exiting pending ==\n");
        }
        catch (Exception exception) {
            this.debug(9, "\t== Exiting pending ==\n");
            throw new CCException(99000043);
        }
    }

    public void put(String string, String string2) {
        this.conf.put(string, string2);
    }

    private Hashtable replaseMessage(Hashtable hashtable) {
        Object object;
        CCMsgTable cCMsgTable = new CCMsgTable(String.valueOf(this.conf.get("MSG_TABLE")) + "." + this.conf.get("ACCEPT_LANG"));
        String string = "MErrMsg";
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            string = "aux-msg";
            string2 = (String)hashtable.get(string);
        }
        String string3 = this.stripMessageCode(string2);
        if (cCMsgTable.isRead()) {
            if (string3 != null && (object = cCMsgTable.find(string3)) != null) {
                hashtable.put(string, object);
                this.debug(9, "\treplaceMessage: msg = " + (String)object + "\n");
            }
        } else {
            this.debug(1, "!!Cannot open message table: " + cCMsgTable.getFile() + "!!\n");
        }
        if (((CCTable)(object = new CCActTable(this.conf.get("AC_TABLE")))).isRead()) {
            if (!hashtable.containsKey("action-code")) {
                hashtable.put(string, ((CCActTable)object).find(string3));
                this.debug(9, "\treplaceMessage: assign action-code: " + ((Hashtable)object).get("action-code") + "\n");
            }
        } else {
            this.debug(1, "!!Cannot open action-code table: " + ((CCTable)object).getFile() + "!!\n");
        }
        return hashtable;
    }

    public Hashtable sendMServer(String string, Hashtable hashtable) {
        Hashtable hashtable2;
        block13: {
            this.debug(2, "== Entering SendMServer ==\n");
            hashtable2 = null;
            try {
                if (string == null) {
                    throw new CCException(99000001);
                }
                if (this.conf.getCCPSHosts().size() == 0) {
                    throw new CCException(99000041, "CCPS_HOST");
                }
                this.checkPendingDirectory();
                this.checkRequestFeild(string, hashtable);
                this.checkCardDigit(hashtable);
                this.addTxnVersion(hashtable);
                if (string.equals("payrequest")) {
                    hashtable2 = this.setPayrequestResponse(hashtable);
                    throw new CCException(99000000);
                }
                String string2 = this.urlEncode2(hashtable);
                Calendar calendar = Calendar.getInstance();
                Vector vector = this.conf.getCCPSHosts();
                int n = calendar.get(13) % vector.size();
                this.debug(5, "Connecting to Payment GWY...\n");
                CCComServer cCComServer = new CCComServer(this.conf, this.log, this.conf.getTimeout());
                String string3 = this.conf.get("HTTP_PROXY_HOST");
                int n2 = 0;
                while (n2 < 2) {
                    try {
                        cCComServer.start((String)vector.elementAt(n), string3, this.conf.get("SECRET"), string, string2);
                        break;
                    }
                    catch (CCException cCException) {
                        if (cCException.getCode() != 99000011 || n2 == 1) {
                            throw cCException;
                        }
                        n = n == vector.size() - 1 ? 0 : ++n;
                        ++n2;
                    }
                }
                this.debug(3, "SendMServer: response = " + CCDebug.blindCardNumberRaw(cCComServer.getResponseMessage()) + "\n");
                hashtable2 = this.urlDecode2(cCComServer.getResponseMessage());
                if (hashtable2.get("MStatus").equals("failure-q-or-cancel") || hashtable2.get("MStatus").equals("failure-q-or-discard")) {
                    this.pending(string, hashtable);
                }
                this.replaseMessage(hashtable2);
            }
            catch (CCException cCException) {
                if (cCException.getCode() == 99000000) break block13;
                try {
                    if (cCException.getCode() == 99000031) {
                        this.pending(string, hashtable);
                    }
                    hashtable2 = this.setLocalError(cCException);
                }
                catch (CCException cCException2) {
                    hashtable2 = this.setLocalError(cCException2);
                }
            }
        }
        this.debug(2, "== Exiting SendMServer ==\n\n");
        return hashtable2;
    }

    private Hashtable setLocalError(CCException cCException) {
        this.debug(7, "\t== Entering setLocalError ==\n");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (cCException.getCode() == 99000031) {
            hashtable.put("MStatus", "failure-q-or-cancel");
        } else {
            hashtable.put("MStatus", "failure-hard");
        }
        hashtable.put("MErrLoc", "ccbsxlib");
        CCMsgTable cCMsgTable = new CCMsgTable(String.valueOf(this.conf.get("MSG_TABLE")) + "." + this.conf.get("ACCEPT_LANG"));
        hashtable.put("MErrMsg", cCMsgTable.find(cCException.getCodeString(), cCException.getMessage()));
        if (!cCMsgTable.isRead()) {
            hashtable.put("MErrMsg", "undefined message.");
            this.debug(1, "!!Cannot open message table: " + cCMsgTable.getFile() + "!!\n");
        }
        CCActTable cCActTable = new CCActTable(this.conf.get("AC_TABLE"));
        hashtable.put("action-code", cCActTable.find(cCException.getCodeString()));
        if (!cCActTable.isRead()) {
            this.debug(1, "!!Cannot open action-code table: " + cCActTable.getFile() + "!!\n");
        }
        this.debug(7, "\t>> MStatus: [[" + hashtable.get("MStatus") + "]]\n");
        this.debug(7, "\t>> MErrLoc: [[" + hashtable.get("MErrLoc") + "]]\n");
        this.debug(7, "\t>> MErrMsg: [[" + hashtable.get("MErrMsg") + "]]\n");
        this.debug(7, "\t>> action-code: [[" + hashtable.get("action-code") + "]]\n");
        this.debug(7, "\t== Exiting setLocalError ==\n");
        return hashtable;
    }

    private Hashtable setPayrequestResponse(Hashtable hashtable) throws CCException {
        this.debug(9, "\t== Entering setPayrequestResponse ==\n");
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("MStatus", "success");
        hashtable2.put("action-code", "000");
        hashtable2.put("order-id", (String)hashtable.get("order-id"));
        hashtable2.put("amount", (String)hashtable.get("amount"));
        hashtable2.put("note", (String)hashtable.get("note"));
        hashtable2.put("accepts", this.conf.get("ACCEPTS"));
        hashtable2.put("url-pay-to", this.conf.get("URL_PAY_TO"));
        this.debug(9, "\t== Exiting setPayrequestResponse ==\n");
        return hashtable2;
    }

    private void setServer(String string) {
        try {
            this.conf = new CCConfig(string);
        }
        catch (Exception exception) {
            this.debug(1, "!!Failed to open config file " + string + "\n");
        }
        this.log = CCDebug.getInstance(this.conf);
    }

    private String stripMessageCode(String string) {
        String string2 = null;
        try {
            int n = string.indexOf(":");
            string2 = n != -1 ? string.substring(0, n) : string;
            Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static String urlDecode(String string) {
        CCQueryString cCQueryString = new CCQueryString(string, 1);
        return cCQueryString.toString();
    }

    private Hashtable urlDecode2(String string) {
        this.debug(9, "\t== Entering urlDecode ==\n");
        CCQueryString cCQueryString = new CCQueryString(string, 3);
        Enumeration enumeration = cCQueryString.keys();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.indexOf("card-number") != -1) {
                this.debug(9, "\t>> " + string2 + ": [[" + CCDebug.blindCardNumber(cCQueryString.get(string2)) + "]]\n");
                continue;
            }
            this.debug(9, "\t>> " + string2 + ": [[" + cCQueryString.get(string2) + "]]\n");
        }
        this.debug(9, "\t== Exiting urlDecode ==\n");
        return cCQueryString;
    }

    public static String urlEncode(String string) {
        CCQueryString cCQueryString = new CCQueryString(string, 2);
        return cCQueryString.toString();
    }

    private String urlEncode2(Hashtable hashtable) {
        this.debug(9, "\t== Entering urlEncode ==\n");
        CCQueryString cCQueryString = new CCQueryString(hashtable, 2);
        Enumeration enumeration = cCQueryString.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.indexOf("card-number") != -1) {
                this.debug(9, "\t<< " + string + ": [[" + CCDebug.blindCardNumber(cCQueryString.get(string)) + "]]\n");
                continue;
            }
            this.debug(9, "\t<< " + string + ": [[" + cCQueryString.get(string) + "]]\n");
        }
        this.debug(9, "\t== Exiting urlEncode ==\n");
        return cCQueryString.toString();
    }
}

