/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.JPGWLib;

import Jp.BuySmart.JPGWLib.Config;
import Jp.BuySmart.JPGWLib.Crypto;
import Jp.BuySmart.JPGWLib.JPGWLibException;
import Jp.BuySmart.JPGWLib.JceResource;
import Jp.BuySmart.JPGWLib.JsseResource;
import Jp.BuySmart.JPGWLib.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;

class ComServer {
    private final String CCVERSION = "2.0";
    private final String UA_LANG = "JAVA";
    private final String CC_CONTENT_TYPE = "Content-type: application/x-www-form-urlencoded";
    private final String HMAC_ALGORITHM = "HMAC-SHA1-160";
    private final String CONTENT_LENGTH = "Content-Length";
    private final int CL_TAG_LEN = "Content-Length".length();
    private final String KEYSTORE_PASSWD = "BuySmartFlex";
    private int timeout = 0;
    private int code = -1;
    private String message = null;
    private Logger log = null;
    private Config conf = null;
    private boolean https = false;
    private Socket socket = null;
    private Socket tunnel = null;
    DataOutputStream dos = null;
    BufferedReader br = null;
    DataOutputStream t_dos = null;
    BufferedReader t_br = null;

    public ComServer(Config conf, int timeout) {
        this.conf = conf;
        this.log = Logger.getLogger(this.getClass());
        this.timeout = timeout;
    }

    public String getResponseMessage() {
        return this.message;
    }

    public int getResponseCode() {
        return this.code;
    }

    public void start(String host, String proxy, String secret, String command, String request) throws JPGWLibException {
        this.log.info((Object)("=== SENDMSERVER to host=" + host + ", secret=" + secret + ", command=" + command + ", proxy=" + proxy + " ===\n"));
        try {
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            String url = host + secret + "/" + command;
            this.checkProtocol(host);
            Hashtable parsed = this.parseUrl(url);
            if (this.https) {
                this.useHttpsConnect((String)parsed.get("host"), Integer.parseInt((String)parsed.get("port")), (String)parsed.get("uri"), proxy, request);
            } else {
                this.useHttpConnect((String)parsed.get("host"), Integer.parseInt((String)parsed.get("port")), (String)parsed.get("uri"), proxy, request);
            }
            this.checkHttpStatusCode();
        }
        catch (JPGWLibException e) {
            boolean pending = command.equals("authonly") || command.equals("mauthonly") || command.equals("authcapture") || command.equals("mauthcapture") || command.equals("postauth") || command.equals("void") || command.equals("return") || command.equals("retry") || command.equals("re-authonly") || command.equals("re-authcapture") || command.equals("directpostauth");
            switch (e.getCode()) {
                case 99000013: {
                    this.log.error((Object)"!!Connected timeout.\n");
                    if (!pending) break;
                    throw new JPGWLibException(99000031);
                }
                case 99000011: {
                    this.log.error((Object)("!!Could not connect payment server: " + host + ".\n"));
                    break;
                }
                case 99000012: {
                    this.log.error((Object)("!!Could not connect proxy server: " + proxy + ".\n"));
                    break;
                }
                case 99000010: {
                    this.log.error((Object)"!!error writing  to socket.\n");
                    break;
                }
                case 99000046: {
                    this.log.error((Object)"!!fail to calculate HMAC.\n");
                    break;
                }
                case 99000022: {
                    if (!pending) break;
                    throw new JPGWLibException(99000031);
                }
            }
            throw e;
        }
        catch (Exception e2) {
            this.log.error((Object)("!!Could not connect payment server: " + host + ".\n"));
            throw new JPGWLibException(99000011);
        }
    }

    private void checkHttpStatusCode() throws JPGWLibException {
        switch (this.code) {
            case 200: {
                break;
            }
            case 401: {
                throw new JPGWLibException(99000014);
            }
            case 403: {
                throw new JPGWLibException(99000015);
            }
            case 404: {
                throw new JPGWLibException(99000016);
            }
            case 500: {
                throw new JPGWLibException(99000017);
            }
            case 501: {
                throw new JPGWLibException(99000018);
            }
            case 503: {
                throw new JPGWLibException(99000019);
            }
            default: {
                throw new JPGWLibException(99000020, String.valueOf(this.code));
            }
        }
    }

    private Hashtable parseUrl(String url) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        int first = 0;
        int end = 0;
        first = url.indexOf("://");
        table.put("protocol", url.substring(0, first));
        end = url.indexOf(":", first + 3);
        table.put("host", url.substring(first + 3, end));
        first = end;
        end = url.indexOf("/", first);
        table.put("port", url.substring(first + 1, end));
        table.put("uri", url.substring(end));
        return table;
    }

    private void checkProtocol(String url) throws JPGWLibException {
        this.https = url.startsWith("https://");
        if (!this.https && !url.startsWith("http://")) {
            throw new JPGWLibException(99000011);
        }
    }

    private void checkCertificate() throws JPGWLibException {
        try {
            ((SSLSocket)this.socket).startHandshake();
            SSLSession session = ((SSLSocket)this.socket).getSession();
            X509Certificate[] x509 = session.getPeerCertificateChain();
            boolean check = false;
            String server = null;
            String invalid_server = "";
            for (int i = 0; i < x509.length; ++i) {
                String subject_dn = ((Object)x509[i].getSubjectDN()).toString();
                int first = subject_dn.indexOf("CN=");
                if (first == -1) continue;
                int end = subject_dn.indexOf(",", first += 3);
                if (check = this.isTrustHost(server = end != -1 ? subject_dn.substring(first, end) : subject_dn.substring(first))) break;
                invalid_server = server + " ";
            }
            if (!check) {
                this.log.error((Object)("!!mismatch host name: " + invalid_server + "\n"));
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new JPGWLibException(99000011);
        }
    }

    private void doTunnelHandshake(String host, int port) throws JPGWLibException {
        try {
            this.t_dos = new DataOutputStream(this.tunnel.getOutputStream());
            this.t_dos.writeBytes("CONNECT " + host + ":" + port + " HTTP/1.0\r\n\r\n");
            this.t_dos.flush();
            this.t_br = new BufferedReader(new InputStreamReader(this.tunnel.getInputStream(), "8859_1"));
            String status = this.t_br.readLine();
            String line = null;
            while (status != null && (line = this.t_br.readLine()) != null && line.length() != 0) {
            }
            if (status == null || !status.startsWith("HTTP/1.0 200")) {
                throw new JPGWLibException(99000011);
            }
        }
        catch (JPGWLibException e1) {
            throw e1;
        }
        catch (IOException e2) {
            if (this.t_br == null) {
                throw new JPGWLibException(99000010);
            }
            throw new JPGWLibException(99000011);
        }
        catch (Exception e3) {
            throw new JPGWLibException(99000011);
        }
    }

    private boolean isTrustHost(String host) {
        if (host == null) {
            return false;
        }
        String trust_hosts = this.conf.get("TRUSTED_HOSTS");
        boolean trust = false;
        StringTokenizer e = new StringTokenizer(trust_hosts, ",");
        while (e.hasMoreElements()) {
            String h = (String)e.nextElement();
            if (!host.equals(h.trim())) continue;
            trust = true;
            break;
        }
        return trust;
    }

    private void receiveData() throws JPGWLibException {
        this.log.info((Object)"== Reading payment server response ==\n");
        String header = "";
        StringBuffer body = new StringBuffer("");
        try {
            int idx;
            this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "8859_1"));
            String line = null;
            line = this.br.readLine();
            if (line != null) {
                idx = line.indexOf(" ");
                if (idx == -1) {
                    throw new JPGWLibException(99000022);
                }
            } else {
                throw new JPGWLibException(99000013);
            }
            String scode = line.substring(idx + 1, idx + 4);
            this.code = Integer.parseInt(scode);
            header = header + line;
            header = header + "\r\n";
            boolean bTrnsEncode = false;
            int ctLength = -1;
            while ((line = this.br.readLine()) != null && line.length() != 0) {
                if (line.compareToIgnoreCase("Transfer-Encoding: chunked") == 0) {
                    bTrnsEncode = true;
                }
                if (line.toLowerCase().startsWith("Content-Length".toLowerCase())) {
                    int idx2 = line.indexOf(":");
                    if (idx2 == -1) {
                        throw new JPGWLibException(99000022);
                    }
                    String s = line.substring(idx2 + 2);
                    ctLength = Integer.parseInt(s, 10);
                }
                header = header + line;
                header = header + "\r\n";
            }
            header = header + "\r\n";
            if (bTrnsEncode) {
                while ((line = this.br.readLine()) != null) {
                    int chunk = Integer.parseInt(line, 16);
                    if (chunk == 0) {
                        line = this.br.readLine();
                        break;
                    }
                    char[] buff = new char[chunk];
                    int cur = 0;
                    int read = 0;
                    while (read < chunk) {
                        if (!this.br.ready()) continue;
                        cur = this.br.read(buff, 0, chunk - read);
                        if (cur == -1) break;
                        read += cur;
                        body.append(buff, 0, cur);
                    }
                    if (chunk != read) {
                        throw new Exception();
                    }
                    buff = null;
                    this.br.readLine();
                }
            } else if (ctLength > -1) {
                char[] buff = new char[ctLength];
                int cur = 0;
                int read = 0;
                while (read < ctLength) {
                    if (!this.br.ready()) continue;
                    cur = this.br.read(buff, 0, ctLength - read);
                    if (cur == -1) break;
                    read += cur;
                    body.append(buff, 0, cur);
                }
                if (ctLength != read) {
                    throw new Exception();
                }
            } else {
                char[] buff = new char[4096];
                int cur = this.br.read(buff, 0, buff.length);
                while (cur > 0) {
                    body.append(buff, 0, cur);
                    cur = this.br.read(buff, 0, buff.length);
                    if (cur != 0) continue;
                    System.err.println("cur == 0!!!");
                }
            }
            int resLen = header.length() + body.length();
            this.log.debug((Object)("recieve data(" + resLen + "):\n" + header + Util.blindCardNumberRaw(body.toString()) + "\n"));
            this.message = body.toString();
        }
        catch (JPGWLibException e0) {
            throw e0;
        }
        catch (InterruptedIOException e1) {
            throw new JPGWLibException(99000013);
        }
        catch (IOException e2) {
            throw new JPGWLibException(99000013);
        }
        catch (Exception e3) {
            throw new JPGWLibException(99000022);
        }
    }

    private void sendData(String uri, String request) throws JPGWLibException {
        boolean to_flag = false;
        try {
            DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
            String provider = JceResource.getInstance().find(this.conf.getSslAlgorithm());
            this.log.debug((Object)("append " + provider));
            String hmac = Crypto.hmac(provider, "HmacSHA1", this.conf.get("KEY_HA1"), request);
            String header = "POST " + uri + " HTTP/1.0\r\n" + "User-Agent: CCBSXLib/" + "2.0" + "(" + "JAVA" + ")\r\n" + "Content-type: application/x-www-form-urlencoded" + "\r\n" + "Content-length: " + request.length() + "\r\n" + "Content-HMAC: h=" + "HMAC-SHA1-160" + "; value=" + hmac + "\r\n" + "Accept-Language: " + this.conf.get("ACCEPT_LANG") + "\r\n\r\n";
            this.log.debug((Object)"Send request.\n");
            dos.writeBytes(header);
            dos.writeBytes(request);
            dos.flush();
            to_flag = true;
            this.log.debug((Object)("Send data\n" + header + Util.blindCardNumberRaw(request) + "\n"));
        }
        catch (JPGWLibException e) {
            throw e;
        }
        catch (Exception e2) {
            if (to_flag) {
                throw new JPGWLibException(99000013);
            }
            throw new JPGWLibException(99000010);
        }
    }

    private void useHttpConnect(String host, int port, String uri, String proxy, String request) throws JPGWLibException {
        try {
            if (proxy != null && proxy.length() != 0) {
                URL obj = new URL("http://" + proxy);
                this.socket = new Socket(obj.getHost(), obj.getPort());
                this.socket.setSoTimeout(this.timeout * 1000);
                this.sendData("http://" + host + ":" + port + uri, request);
            } else {
                this.socket = new Socket(host, port);
                this.socket.setSoTimeout(this.timeout * 1000);
                this.sendData(uri, request);
            }
            this.receiveData();
        }
        catch (JPGWLibException e0) {
            throw e0;
        }
        catch (Exception e1) {
            if (proxy != null && proxy.length() != 0) {
                throw new JPGWLibException(99000012);
            }
            throw new JPGWLibException(99000011);
        }
        finally {
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    private void useHttpsConnect(String host, int port, String uri, String proxy, String request) throws JPGWLibException {
        try {
            String name = JsseResource.getInstance().find(this.conf.getSslAlgorithm());
            this.log.debug((Object)("append " + name));
            Security.addProvider((Provider)Class.forName(name).newInstance());
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.log.error((Object)"\tcan't append JSSE Provider.\n");
            throw new JPGWLibException(99000011);
        }
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.conf.getSslAlgorithm());
            KeyStore ks = null;
            try {
                ks = KeyStore.getInstance("JKS");
                File cacert = new File(this.conf.getPath("CERT_FILE"));
                ks.load(new FileInputStream(cacert), "BuySmartFlex".toCharArray());
            }
            catch (Exception e1) {
                this.log.error((Object)("!!fail to use a certificate file: " + this.conf.getPath("CERT_FILE") + "!!\n"));
                throw new JPGWLibException(99000011);
            }
            tmf.init(ks);
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            if (proxy != null && proxy.length() != 0) {
                URL obj = new URL("http://" + proxy);
                this.tunnel = new Socket(obj.getHost(), obj.getPort());
                this.tunnel.setSoTimeout(this.timeout * 1000);
                this.doTunnelHandshake(host, port);
                this.socket = (SSLSocket)factory.createSocket(this.tunnel, host, port, true);
                this.socket.setSoTimeout(this.timeout * 1000);
                this.checkCertificate();
                this.sendData("https://" + host + ":" + port + uri, request);
            } else {
                this.socket = (SSLSocket)factory.createSocket(host, port);
                this.socket.setSoTimeout(this.timeout * 1000);
                this.checkCertificate();
                this.sendData(uri, request);
            }
            this.receiveData();
        }
        catch (JPGWLibException e0) {
            throw e0;
        }
        catch (NoSuchAlgorithmException e2) {
            this.log.debug((Object)e2.getMessage(), (Throwable)e2);
            this.log.error((Object)"\tcan't create SSL Context\n");
            throw new JPGWLibException(99000011);
        }
        catch (Exception e3) {
            if (proxy != null && proxy.length() != 0) {
                throw new JPGWLibException(99000012);
            }
            throw new JPGWLibException(99000011);
        }
        finally {
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                if (this.tunnel != null) {
                    this.tunnel.close();
                }
            }
            catch (Exception e5) {}
        }
    }
}

