/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.JPGWLib;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Config
extends Properties {
    public static final String LIB_ROOT = "LIB_ROOT";
    public static final String CCPS_HOSTS = "CCPS_HOSTS";
    public static final String SECRET = "SECRET";
    public static final String KEY_HA1 = "KEY_HA1";
    public static final String TRUSTED_HOSTS = "TRUSTED_HOSTS";
    public static final String CERT_FILE = "CERT_FILE";
    public static final String ACCEPTS = "ACCEPTS";
    public static final String URL_PAY_TO = "URL_PAY_TO";
    public static final String ACCEPT_LANG = "ACCEPT_LANG";
    public static final String AC_TABLE = "AC_TABLE";
    public static final String MSG_TABLE = "MSG_TABLE";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String USE_PENDING_LOGGING = "USE_PENDING_LOGGING";
    public static final String PENDING_DIR = "PENDING_DIR";
    public static final String USE_HTTP_PROXY = "USE_HTTP_PROXY";
    public static final String HTTP_PROXY_HOST = "HTTP_PROXY_HOST";
    public static final String SSL_ALGORITHM = "SSL_ALGORITHM";
    public static final String AD_FLAG = "AD_FLAG";
    public static final String AD_CHARSET = "AD_CHARSET";
    public static final String AD_SCALE = "AD_SCALE";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public String[][] DEFAULT_VALUES = new String[][]{{"LIB_ROOT", "/usr/local/buysmart/jpgwlib"}, {"CCPS_HOSTS", "https://pay5.cybercash.co.jp:443/,http://pay6.cybercash.co.jp:443/"}, {"SECRET", "secret"}, {"KEY_HA1", "000000000000000000000000000000000000"}, {"TRUSTED_HOSTS", "pay1.cybercash.co.jp,pay2.cybercash.co.jp,pay3.cybercash.co.jp,pay4.cybercash.co.jp,pay5.cybercash.co.jp,pay6.cybercash.co.jp,pay7.cybercash.co.jp,pay8.cybercash.co.jp,pay9.cybercash.co.jp"}, {"CERT_FILE", "cckkca"}, {"ACCEPTS", "mc,dc"}, {"URL_PAY_TO", "http://www.cybercash.co.jp/payment.cgi"}, {"ACCEPT_LANG", "ja"}, {"AC_TABLE", "actioncode.def"}, {"MSG_TABLE", "msg_table"}, {"TIMEOUT", "120"}, {"USE_PENDING_LOGGING", "false"}, {"PENDING_DIR", "pending"}, {"USE_HTTP_PROXY", "false"}, {"HTTP_PROXY_HOST", "localhost:8080"}, {"SSL_ALGORITHM", "SunX509"}, {"AD_FLAG", "0"}, {"AD_CHARSET", "UTF-8"}, {"AD_SCALE", "001"}};

    public void setAdFlag(String adFlag) {
        this.put(AD_FLAG, adFlag);
    }

    public String getAdFlag() {
        return this.get(AD_FLAG);
    }

    public void setAdCharset(String adCharset) {
        this.put(AD_CHARSET, adCharset);
    }

    public String getAdCharset() {
        return this.get(AD_CHARSET);
    }

    public void setAdScale(String adScale) {
        this.put(AD_SCALE, adScale);
    }

    public String getAdScale() {
        return this.get(AD_SCALE);
    }

    public Config(String filename) throws Exception {
        this.init();
        FileInputStream fis = new FileInputStream(filename);
        this.load(fis);
        fis.close();
    }

    public Config(Properties prop) throws Exception {
        this.init();
        this.putAll((Map<?, ?>)prop);
    }

    void init() {
        Iterator i = Arrays.asList(this.DEFAULT_VALUES).iterator();
        while (i.hasNext()) {
            String[] kv = (String[])i.next();
            this.put(kv[0], kv[1]);
        }
    }

    protected Config() {
        this.init();
    }

    public Object clone() {
        Config copy = new Config();
        Iterator<Object> i = this.keySet().iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            copy.put(new String(k), new String(this.get(k)));
        }
        return copy;
    }

    public String getSecret() {
        return this.get(SECRET);
    }

    public void setSecret(String secret) {
        this.put(SECRET, secret);
    }

    public String getKeyHA1() {
        return this.get(KEY_HA1);
    }

    public void setKeyHA1(String keyHA1) {
        this.put(KEY_HA1, keyHA1);
    }

    public void setAcceptLanguage(String lang) {
        this.put(ACCEPT_LANG, lang);
    }

    public String getAcceptLanguage() {
        return this.get(ACCEPT_LANG);
    }

    public void setTimeOut(int sec) {
        this.put(TIMEOUT, Integer.toString(sec));
    }

    public int getTimeOut() {
        return Integer.parseInt(this.get(TIMEOUT));
    }

    public void setPendingDir(String pendingDir) {
        this.put(PENDING_DIR, pendingDir);
    }

    public String getPendingDir() {
        return this.getPath(PENDING_DIR);
    }

    public void setUsePendingLogging(boolean flag) {
        if (flag) {
            this.put(USE_PENDING_LOGGING, TRUE);
        } else {
            this.put(USE_PENDING_LOGGING, FALSE);
        }
    }

    public boolean getUsePendingLogging() {
        return this.getBool(USE_PENDING_LOGGING);
    }

    public boolean getBool(String key) {
        String val = this.get(key);
        return val.equalsIgnoreCase(TRUE);
    }

    public String get(String key) {
        String value = (String)super.get(key);
        if (value == null) {
            value = "";
        }
        return value.trim();
    }

    public void put(String key, String value) {
        super.put(key, value);
    }

    public String getPath(String key) {
        return Config.completePath(this.get(LIB_ROOT), this.get(key));
    }

    public Vector getCCPSHosts() {
        Vector<String> v = new Vector<String>();
        StringTokenizer e = new StringTokenizer(this.get(CCPS_HOSTS), ",");
        while (e.hasMoreElements()) {
            String h = (String)e.nextElement();
            v.add(h.trim());
        }
        return v;
    }

    public static String completePath(String root, String path) {
        File f1 = new File(path);
        if (f1.isAbsolute()) {
            return f1.getAbsolutePath();
        }
        File f2 = new File(root, path);
        return f2.getAbsolutePath();
    }

    public String getSslAlgorithm() {
        return this.get(SSL_ALGORITHM);
    }

    public void setSslAlgorithm(String name) {
        this.put(SSL_ALGORITHM, name);
    }
}

