<?php
/*
Template Name: アートメイク
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_daisy"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--artmake------------------->
  <section class="page_cnts">
    <h2>Art Make<span>医療アートメイク</span></h2>
    <p>デイジークリニックでは、アートメイクを専門的に扱っております。<br>
      眉毛、アイライン、唇、ほくろ、へアラインなど様々なお顔のお悩みを解決いたします。</p>
  </section>
  
  <!--pickup------------------->
  <section class="page_pickup">
    <h2>Pick Up<span>おすすめメニュー</span></h2>
    <div class="inner">
      <dl>
        <a href="#eyebrow">
        <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/eyebrow2.webp"> </dt>
        <dd>dazzy brow
          <ul>
            <li>2回</li>
            <li>眉</li>
          </ul>
          <p class="price">132,000円<span>(税込)</span></p>
        </dd>
        </a>
      </dl>
      <dl>
        <a href="#lip">
        <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/lip4.webp"> </dt>
        <dd>dazzy lip
          <ul>
            <li>2回</li>
            <li>唇</li>
          </ul>
          <p class="price">132,000円<span>(税込)</span></p>
        </dd>
        </a>
      </dl>
    </div>
  </section>
  
  <!--nayami------------------->
  <section class="nayami">
    <h2>あなたのお悩みは何ですか？</h2>
    <div class="nayami_img"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/artmake.webp"></div>
    <div class="arrow">
      <div class="inner">
        <dl>
          <dt>眉毛</dt>
          <dd>
            <ul>
              <li><span>眉がうまく描けない</span></li>
              <li><span>眉⽑がよく消える</span></li>
            </ul>
          </dd>
        </dl>
        <dl>
          <dt>唇</dt>
          <dd>
            <ul>
              <li><span>⾷事で⼝紅が落ちるのが嫌</span></li>
              <li><span>唇が薄い、⾎⾊が悪い</span></li>
            </ul>
          </dd>
        </dl>
        <dl>
          <dt>アイライン</dt>
          <dd>
            <ul>
              <li><span>すっぴんに⾃信がない</span></li>
              <li><span>アイラインがうまくひけない</span></li>
            </ul>
          </dd>
        </dl>
        <dl>
          <dt>ほくろ</dt>
          <dd>
            <ul>
              <li><span>涙ぼくろが欲しい</span></li>
              <li><span>平凡な顔である</span></li>
            </ul>
          </dd>
        </dl>
        <dl>
          <dt>ヘアライン</dt>
          <dd>
            <ul>
              <li><span>⼩顔に⾒せたい</span></li>
              <li><span>おでこの⽣え際が気になる</span></li>
            </ul>
          </dd>
        </dl>
      </div>
    </div>
    <div class="nayami_btm">
      <div>
        <h3>これを全て叶えるのが<br class="SP">
          アートメイクです！</h3>
        <p>今よりもすっぴんが好きになれる！<br class="SP">
          メイクが楽になる！<br>
          <br class="SP">
          そんなドラマティックな<br class="SP">
          アートメイクをご提案します。</p>
      </div>
    </div>
  </section>
  
  <!--eyebrow------------------->
  <section class="page_cnts" id="eyebrow">
    <h2>Eyebrow<span>眉毛アートメイク</span></h2>
    <p>デイジークリニックのアイブロウアートメイクは、<br>
      メニューの種類が豊富です。</p>
    <div class="point3">
      <p>メニュー</p>
      <span>×</span>
      <p>デザイン</p>
      <span>×</span>
      <p>カラー</p>
    </div>
  </section>
  
  <!--artmake_menu------------------->
  <section class="page_cnts">
    <h3>メニュー</h3>
    <div class="artmake_menu">
      <p class="top"><span>オススメ！</span>dazzy brow</p>
      <div class="left">
        <p class="img">
          <?php
          $fields = scf::get( 'dazzy_brow_illust' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <p class="text">
          <?php $myfield = scf::get('dazzy_brow_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div class="right">
        <h4>こんな方におすすめ</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'dazzy_brow_osusume', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_osusume_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['dazzy_brow_osusume_li']; ?></li>
          <?php } } ?>
        </ul>
        <h4>メリット</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'dazzy_brow_merit', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_merit_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['dazzy_brow_merit_li']; ?></li>
          <?php } } ?>
        </ul>
        <h4>デメリット</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'dazzy_brow_demerit', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_demerit_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['dazzy_brow_demerit_li']; ?></li>
          <?php } } ?>
        </ul>
      </div>
      <div class="dazzybrow">
        <p class="top"><span>1番人気</span>dazzy browのポイント</p>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'dazzy_brow_point', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_point_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['dazzy_brow_point_li']; ?></li>
          <?php } } ?>
        </ul>
      </div>
    </div>
    <!---->
    <div class="artmake_menu">
      <p class="top">natural brow</p>
      <div class="left">
        <p class="img">
          <?php
          $fields = scf::get( 'natural_brow_illust' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <p class="text">
          <?php $myfield = scf::get('natural_brow_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div class="right">
        <h4>こんな方におすすめ</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'natural_brow_osusume', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_osusume_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['natural_brow_osusume_li']; ?></li>
          <?php } } ?>
        </ul>
        <h4>メリット</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'natural_brow_merit', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_merit_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['natural_brow_merit_li']; ?></li>
          <?php } } ?>
        </ul>
        <h4>デメリット</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'natural_brow_demerit', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'dazzy_brow_demerit_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['natural_brow_demerit_li']; ?></li>
          <?php } } ?>
        </ul>
      </div>
    </div>
    <!---->
    <div class="artmake_menu">
      <p class="top">powder brow</p>
      <div class="left">
        <p class="img">
          <?php
          $fields = scf::get( 'powder_brow_illust' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <p class="text">
          <?php $myfield = scf::get('powder_brow_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div class="right">
        <h4>こんな方におすすめ</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'powder_brow_osusume', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'powder_brow_osusume_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['powder_brow_osusume_li']; ?></li>
          <?php } } ?>
        </ul>
        <h4>メリット</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'powder_brow_merit', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'powder_brow_merit_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['powder_brow_merit_li']; ?></li>
          <?php } } ?>
        </ul>
        <h4>デメリット</h4>
        <ul class="check">
          <?php
          $free_item = SCF::get( 'powder_brow_demerit', 167 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'powder_brow_demerit_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['powder_brow_demerit_li']; ?></li>
          <?php } } ?>
        </ul>
      </div>
    </div>
  </section>
  
  <!--artmake_design------------------->
  <section class="page_cnts">
    <h3>デザイン</h3>
    <div class="artmake_design">
      <div>
        <p class="img">
          <?php
          $fields = scf::get( 'eyebrow_heiko_img' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <h4>平⾏眉</h4>
        <p>
          <?php $myfield = scf::get('eyebrow_heiko_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div>
        <p class="img">
          <?php
          $fields = scf::get( 'eyebrow_arch_img' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <h4>アーチ眉</h4>
        <p>
          <?php $myfield = scf::get('eyebrow_arch_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div>
        <p class="img">
          <?php
          $fields = scf::get( 'eyebrow_elegant_img' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <h4>エレガント眉</h4>
        <p>
          <?php $myfield = scf::get('eyebrow_elegant_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div>
        <p class="img">
          <?php
          $fields = scf::get( 'eyebrow_up_img' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
        <h4>上がり眉</h4>
        <p>
          <?php $myfield = scf::get('eyebrow_up_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
    </div>
  </section>
  
  <!--artmake_color------------------->
  <section class="page_cnts">
    <h3>カラー</h3>
    <div class="artmake_color">
      <h4>お一人おひとりに似合うカラーを<br class="SP">
        デザインいたします。</h4>
      <p class="img">
        <?php
        $fields = scf::get( 'eyebrow_color' );
        echo wp_get_attachment_image( $fields, 'large' );
        ?>
      </p>
      <p class="att">※画像はイメージです</p>
    </div>
  </section>
  
  <!--artmake_policy------------------->
  <section class="artmake_policy" style="margin-top:2em;">
    <div>デイジークリニックの<br class="SP">
      アイブロウデザインは、<br>
      専⾨クリニックだからこその<br class="SP">
      ポリシーがあります。</div>
    <ul>
      <li><span>眉の⻩⾦比</span></li>
      <li><span>お顔全体の<br>
        統⼀感</span></li>
      <li><span>メイクとの<br>
        バランス</span></li>
      <li><span>肌質と<br>
        ⾊素の相性</span></li>
      <li><span>普段の<br>
        ケア⽅法</span></li>
    </ul>
    <div class="counseling">
      <h4>無料カウンセリングはこちら</h4>
      <p>オンラインカウンセリングも可能です。</p>
      <div class="btn"><a href="https://reservation.medical-force.com/c/36ed8b598ac34986bdc23ac30e2021e7/reservations/new?menu_entrance_id=48b69762-203d-4ecb-be3f-d3a0ac53ce4c" target="_blank">新宿本院の予約はこちら</a></div>
      <div class="btn" style="margin-top: 1em;"><a href="https://reservation.medical-force.com/c/3d0753af8bda42caa7cdbbbed8b027d9/reservations/new?menu_entrance_id=454c0f14-57de-4ddb-a6c6-0e61fbcf850d&_gl=1*1jtgb7q*_gcl_au*MjgyNzIwMjU4LjE3Mzk0MzIzNDE.&_ga=2.161017021.1081203531.1739777188-611588450.1730447120&_ebx=1cmhjtt2crh.1729576495.7zq7k5k" target="_blank">札幌院の予約はこちら</a></div>
      <div class="btn" style="margin-top: 1em;"><a href="https://reservation.medical-force.com/c/0a865e188155486b851fb31ae1722893/reservations/new?menu_entrance_id=af395f96-92c8-49f6-b5fe-8cd5ea6f1078&_gl=1*j1o10k*_gcl_au*MjgyNzIwMjU4LjE3Mzk0MzIzNDE.&_ga=2.161137469.1081203531.1739777188-611588450.1730447120&_ebx=1cmhjtt2crh.1729576495.7zq7khx" target="_blank">福岡院の予約はこちら</a></div>
      <?php/*<div class="btn" style="margin-top: 1em;"><a href="https://reservation.medical-force.com/c/5e64601b249749ca90359568a89adcc8/reservations/new?menu_entrance_id=6c00ae2f-a4fa-4634-a8f9-5f870991c92e" target="_blank">大阪心斎橋院の予約はこちら</a></div>*/?>
    </div>
  </section>
  
  <!--artmake_case------------------->
  <section class="artmake_case">
    <h3>症例のご紹介</h3>
    <ul class="slider02">
      <?php
      $free_item = SCF::get( 'eyebrow_case', 167 );
      foreach ( $free_item as $fields ) {
        if ( $fields[ 'eyebrow_case_name' ] !== "" ) {
          ?>
      <li>
        <div class="slider02_left"><?php echo wp_get_attachment_image($fields['eyebrow_case_img'], 'large');?></div>
        <div class="slider02_right">
          <dl>
            <dt>施術内容</dt>
            <dd><?php echo $fields['eyebrow_case_menu']; ?></dd>
            <dt>価格</dt>
            <dd><?php echo $fields['eyebrow_case_price']; ?></dd>
            <?php if(get_post_meta($post->ID, 'eyebrow_case_time', true)): ?>
            <dt>回数</dt>
            <dd><?php echo $fields['eyebrow_case_time']; ?></dd>
            <?php endif; ?>
          </dl>
          <?php if(get_post_meta($post->ID, 'eyebrow_case_side', true)): ?>
          <p class="risk"><span>副作用・リスク</span> <?php echo nl2br($fields['eyebrow_case_side']); ?> </p>
          <?php endif; ?>
        </div>
      </li>
      <?php } } ?>
    </ul>
    <?php
    /*<div class="att">
         <?php $myfield = scf::get('eyebrow_case_att', 167); if( !empty( $myfield )){ ?>
         <p> <?php echo nl2br( $myfield ); ?> </p>
         <?php } ?>
       </div>*/
    ?>
    <div class="inner">
      <p> Instagramで症例をご紹介しています </p>
    </div>
    <div class="btn_ig"><a href="https://www.instagram.com/explore/tags/%E3%83%87%E3%82%A4%E3%82%B8%E3%83%BC%E3%82%AF%E3%83%AA%E3%83%8B%E3%83%83%E3%82%AF%E7%9C%89%E3%82%A2%E3%83%BC%E3%83%88%E3%83%A1%E3%82%A4%E3%82%AF%E7%97%87%E4%BE%8B/"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/03/icon_ig.png"  alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50" loading="lazy">
      <p>@dazzy_clinic<span>デイジークリニック公式</span></p>
      </a></div>
  </section>
  
  <!--artmake_policy------------------->
  <?php
  /*<section class="artmake_case">
     <h3>Instagram</h3>
     <p class="text">インスタグラムでも<br>
       症例をご紹介しております。</p>
     <?php echo do_shortcode('[instagram-feed feed=5]'); ?> </section>*/
  ?>
  
  <!--lip------------------->
  <section class="page_cnts" id="lip">
    <h2>Lip<span>リップアートメイク</span></h2>
    <p>デイジークリニックのリップアートメイクは、<br>
      3つのメニューから選べます。</p>
  </section>
  
  <!--artmake_menu------------------->
  <section class="page_cnts">
    <h3>メニュー</h3>
    <div class="artmake_menu">
      <p class="top"><?php/*<span>オススメ！</span>*/?>dazzy Lip</p>
      <div class="left">
        <p class="img">
          <?php
          $fields = scf::get( 'dazzy_lip_illust' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
      </div>
      <div class="right">
        <p class="text">
          <?php $myfield = scf::get('dazzy_lip_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
      <div class="dazzybrow">
        <p class="top"><span>PICK UP</span>dazzy Lipのおすすめポイント</p>
        <ul class="check">
          <li>従来の塗りつぶし⼿法（⼝紅をしっかり塗ったようなリップ）とは異なるDAZZY CLINIC独⾃の新技術</li>
          <li>肌への負担が少ないから、色素沈着を起こしにくい</li>
          <li>スピーディーかつ繊細な施術が可能 ※スタッフにより異なる</li>
        </ul>
      </div>
    </div>
    <?php/*
    <div class="artmake_menu">
      <p class="top">グラデーションLIP</p>
      <div class="left">
        <p class="img">
          <?php
          $fields = scf::get( 'gradation_lip_illust' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
      </div>
      <div class="right">
        <p class="text">
          <?php $myfield = scf::get('gradation_lip_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
    </div>
    <!---->
    <div class="artmake_menu">
      <p class="top">カイリーLIP</p>
      <div class="left">
        <p class="img">
          <?php
          $fields = scf::get( 'kylie_lip_illust' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </p>
      </div>
      <div class="right">
        <p class="text">
          <?php $myfield = scf::get('kylie_lip_txt'); echo nl2br( $myfield ); ?>
        </p>
      </div>
    </div>*/?>
  </section>
  
  <!--artmake_color------------------->
  <section class="page_cnts">
    <h3>カラー</h3>
    <div class="artmake_color">
      <h4>お一人おひとりに似合うカラーを<br class="SP">
        デザインいたします。</h4>
      <p class="img">
        <?php
        $fields = scf::get( 'lip_color' );
        echo wp_get_attachment_image( $fields, 'large' );
        ?>
      </p>
      <p class="att">※画像はイメージです</p>
    </div>
  </section>
  
  <!--artmake_policy------------------->
  <section class="artmake_policy" style="margin-top:2em;">
    <?php
    /*<div>
         <?php $myfield = scf::get('lipbalm_txt'); echo nl2br( $myfield ); ?>
       </div>
       <p class="img">
         <?php
         $fields = scf::get( 'lipbalm' );
         echo wp_get_attachment_image( $fields, 'large' );
         ?>
       </p>*/
    ?>
    <div class="counseling">
      <h4>無料カウンセリングはこちら</h4>
      <p>オンラインカウンセリングも可能です。</p>
      <div class="btn"><a href="https://reservation.medical-force.com/c/36ed8b598ac34986bdc23ac30e2021e7/reservations/new?menu_entrance_id=48b69762-203d-4ecb-be3f-d3a0ac53ce4c" target="_blank">新宿本院の予約はこちら</a></div>
      <div class="btn" style="margin-top: 1em;"><a href="https://reservation.medical-force.com/c/3d0753af8bda42caa7cdbbbed8b027d9/reservations/new?menu_entrance_id=454c0f14-57de-4ddb-a6c6-0e61fbcf850d&_gl=1*1jtgb7q*_gcl_au*MjgyNzIwMjU4LjE3Mzk0MzIzNDE.&_ga=2.161017021.1081203531.1739777188-611588450.1730447120&_ebx=1cmhjtt2crh.1729576495.7zq7k5k" target="_blank">札幌院の予約はこちら</a></div>
      <div class="btn" style="margin-top: 1em;"><a href="https://reservation.medical-force.com/c/0a865e188155486b851fb31ae1722893/reservations/new?menu_entrance_id=af395f96-92c8-49f6-b5fe-8cd5ea6f1078&_gl=1*j1o10k*_gcl_au*MjgyNzIwMjU4LjE3Mzk0MzIzNDE.&_ga=2.161137469.1081203531.1739777188-611588450.1730447120&_ebx=1cmhjtt2crh.1729576495.7zq7khx" target="_blank">福岡院の予約はこちら</a></div>
      <?php/*<div class="btn" style="margin-top: 1em;"><a href="https://reservation.medical-force.com/c/5e64601b249749ca90359568a89adcc8/reservations/new?menu_entrance_id=6c00ae2f-a4fa-4634-a8f9-5f870991c92e" target="_blank">大阪心斎橋院の予約はこちら</a></div>*/?>
    </div>
  </section>
  
  <!--artmake_case------------------->
  <section class="artmake_case">
    <h3>症例のご紹介</h3>
    <ul class="slider02">
      <?php
      $free_item = SCF::get( 'lip_case', 167 );
      foreach ( $free_item as $fields ) {
        if ( $fields[ 'lip_case_name' ] !== "" ) {
          ?>
      <li>
        <div class="slider02_left"><?php echo wp_get_attachment_image($fields['lip_case_img'], 'large');?></div>
        <div class="slider02_right">
          <dl>
            <dt>施術内容</dt>
            <dd><?php echo $fields['lip_case_menu']; ?></dd>
            <dt>価格</dt>
            <dd><?php echo $fields['lip_case_price']; ?></dd>
            <?php if(get_post_meta($post->ID, 'lip_case_time', true)): ?>
            <dt>回数</dt>
            <dd><?php echo $fields['lip_case_time']; ?></dd>
            <?php endif; ?>
          </dl>
          <?php if(get_post_meta($post->ID, 'lip_case_side', true)): ?>
          <p class="risk"><span>副作用・リスク</span> <?php echo nl2br($fields['lip_case_side']); ?> </p>
          <?php endif; ?>
        </div>
      </li>
      <?php } } ?>
    </ul>
    <?php
    /*<div class="att">
         <?php $myfield = scf::get('lip_case_att', 167); if( !empty( $myfield )){ ?>
         <p> <?php echo nl2br( $myfield ); ?> </p>
         <?php } ?>
       </div>*/
    ?>
    <div class="inner">
      <p> Instagramで症例をご紹介しています </p>
    </div>
    <div class="btn_ig"><a href="https://www.instagram.com/explore/tags/%E3%83%87%E3%82%A4%E3%82%B8%E3%83%BC%E3%82%AF%E3%83%AA%E3%83%8B%E3%83%83%E3%82%AF%E3%83%AA%E3%83%83%E3%83%97%E3%82%A2%E3%83%BC%E3%83%88%E3%83%A1%E3%82%A4%E3%82%AF%E7%97%87%E4%BE%8B/"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/03/icon_ig.png"  alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50" loading="lazy">
      <p>@dazzy_clinic<span>デイジークリニック公式</span></p>
      </a></div>
  </section>
  
  <!--artmake_policy------------------->
  <?php
  /*<section class="artmake_case">
     <h3>Instagram</h3>
     <p class="text">インスタグラムでも<br>
       症例をご紹介しております。</p>
     <?php echo do_shortcode('[instagram-feed feed=6]'); ?> </section>*/
  ?>
  
  <!--other------------------->
  <section class="artmake_other" id="eyeline">
    <h2>Eyeline<span>アイラインアートメイク</span></h2>
    <p>
      <?php $myfield = scf::get('eyeline_txt'); echo nl2br( $myfield ); ?>
    </p>
    <div class="other_bui">
      <dl>
        <dt>アイライン上</dt>
        <dd>
          <?php
          $fields = scf::get( 'eyeline_top' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </dd>
      </dl>
      <dl>
        <dt>アイライン上下</dt>
        <dd>
          <?php
          $fields = scf::get( 'eyeline_top_bottom' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </dd>
      </dl>
    </div>
  </section>
  
  <!--other------------------->
  <section class="artmake_other" id="mole">
    <h2>Mole<span>ほくろアートメイク</span></h2>
    <p>
      <?php $myfield = scf::get('mole_txt'); echo nl2br( $myfield ); ?>
    </p>
    <div class="other_bui">
      <dl>
        <dt>泣きぼくろ</dt>
        <dd>
          <?php
          $fields = scf::get( 'mole_eye' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </dd>
      </dl>
      <dl>
        <dt>艶ほくろ</dt>
        <dd>
          <?php
          $fields = scf::get( 'mole_lip' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </dd>
      </dl>
    </div>
  </section>
  
  <!--other------------------->
  <section class="artmake_other" id="hairline">
    <h2>Hairline<span>ヘアラインアートメイク</span></h2>
    <p>
      <?php $myfield = scf::get('hairline_txt'); echo nl2br( $myfield ); ?>
    </p>
    <div class="other_bui">
      <dl>
        <dt>生え際全体</dt>
        <dd>
          <?php
          $fields = scf::get( 'hairline_all' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </dd>
      </dl>
      <dl>
        <dt>M字部分</dt>
        <dd>
          <?php
          $fields = scf::get( 'hairline_m' );
          echo wp_get_attachment_image( $fields, 'large' );
          ?>
        </dd>
      </dl>
    </div>
  </section>
  
  <!--other------------------->
  <section class="page_howto">
    <h2>How To<span>施術の流れ</span></h2>
    <?php
    $free_item = SCF::get( 'page_howto', 167 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'page_howto_step' ] !== "" ) {
        ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['page_howto_img'], 'large');?></dt>
      <dd>
        <p class="step"><?php echo $fields['page_howto_step']; ?></p>
        <p class="time"><?php echo $fields['page_howto_time']; ?></p>
        <p class="tit"><?php echo $fields['page_howto_tit']; ?></p>
        <?php echo nl2br( $fields['page_howto_txt'] ); ?>
    </dl>
    <?php } } ?>
  </section>
  
  <!--price------------------->
  <section class="page_price">
    <h2>Price<span>料金のご案内</span></h2>
    <div class="trainee">
      <p>料金表は各院によって異なる場合がございます。<br>
        施術を希望される院の料金表をお選びください。</p>
    </div>
    <div class="price_box">
      <div class="btn"><a href="https://www.dazzyclinic.jp/cliniclist/shinjuku/#price">新宿本院</a></div>
      <div class="btn"><a href="https://www.dazzyclinic.jp/cliniclist/sapporo/#price">札幌院</a></div>
      <?php/* <div class="btn"><a href="https://www.dazzyclinic.jp/cliniclist/osaka/#price">心斎橋院</a></div>*/?>
      <div class="btn"><a href="https://www.dazzyclinic.jp/cliniclist/fukuoka/#price">福岡院</a></div>
    </div>
    <?php
    /* 
    <h3>眉アートメイク※2回コース</h3>
    <?php echo do_shortcode('[table id=1 /]'); ?>
	 <h3>眉アートメイク※1回コース</h3>
    <?php echo do_shortcode('[table id=21 /]'); ?>
	  <p class="att">※１回メニューは渋谷・新宿のみ</p>
    <h3>リップアートメイク※2回コース</h3>
    <?php echo do_shortcode('[table id=2 /]'); ?>
	  	 <h3>リップアートメイク※1回コース</h3>
    <?php echo do_shortcode('[table id=22 /]'); ?>
	  <p class="att">※１回メニューは渋谷・新宿のみ</p>
    <h3>アイラインアートメイク※2回コース</h3>
    <?php echo do_shortcode('[table id=3 /]'); ?>
	  	 <h3>アイラインアートメイク※1回コース</h3>
    <?php echo do_shortcode('[table id=23 /]'); ?>
	  <p class="att">※１回メニューは渋谷・新宿のみ</p>
    <h3>ほくろアートメイク※1回コース</h3>
    <?php echo do_shortcode('[table id=4 /]'); ?>
    <h3>ヘアラインアートメイク※2回コース</h3>
    <?php echo do_shortcode('[table id=5 /]'); ?>
	  <!-- <h3>ヘアラインアートメイク※1回コース</h3>
    <?php echo do_shortcode('[table id=24 /]'); ?>
	  <p class="att">※１回メニューは渋谷・新宿のみ</p> -->
    <div class="trainee">
      <h4>
        <?php $myfield = scf::get('trainee_tit'); echo ( $myfield ); ?>
      </h4>
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <p class="zeikomi">料金はすべて税込です</p>

  */
    ?>
  </section>
  
  <!--faq------------------->
  <section class="faq page_faq">
    <h2>FAQ<span>よくある質問</span></h2>
    <?php
    $free_item = SCF::get( 'page_faq', 167 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'page_faq_q' ] !== "" ) {
        ?>
    <dl>
      <dt class="faq_tit js_tit">
        <p><?php echo $fields['page_faq_q']; ?></p>
      </dt>
      <dd class="faq_content">
        <p><?php echo nl2br($fields['page_faq_a']); ?></p>
      </dd>
    </dl>
    <?php } } ?>
    <div class="btn"><a href="https://www.dazzyclinic.jp/faq/">その他のよくある質問</a></div>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
