<?php
/*
Template Name: NIPT
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_daisy"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--NIPT------------------->
  <section class="about_clinic">
    <h2>NIPT<span>新型出生前診断</span></h2>
  </section>
  
  <!--サンセットプラン------------------->
  <section class="iten_info">
    <div class="iten_box">
      <h3>新宿本院<br class="SP">
        【サンセットプラン】ご案内開始 <span>～夕方16時以降にご来院頂ける方限定～ </span></h3>
      <p style="text-align: center;">電話予約のみのご案内<br>
        ※WEB予約からの切り替えは出来ません </p>
      <div class="color_box">
        <h4 style="margin-top: 0;">電話:<a href="tel:0362770045">03-6277-0045</a></h4>
        <p>受付時間：10:00～18:00<br>
          女性スタッフが対応いたします。お気軽にご連絡ください。 </p>
      </div>
    </div>
    <div class="iten_box">
      <h4>検査費用</h4>
      <table>
        <tbody>
          <tr>
            <th>全染色体＋微小欠失検査</th>
            <td>¥205,000</td>
          </tr>
          <tr>
            <th>全染色体検査</th>
            <td>¥170,000</td>
          </tr>
          <tr>
            <th>基本検査</th>
            <td>¥139,000</td>
          </tr>
        </tbody>
      </table>
      <p class="zeikomi">料金はすべて税込です</p>
      <h4>スピーディスタイルにてご案内します</h4>
      <p>スピーディースタイルは体力に自信がない、手短に済ませたい方向けのスタイル。個室にて採血、お会計までワンストップで進めます。<br>
        パンフレットをお持ち帰りいただけますので、お時間のあるときにゆっくりとご覧ください。</p>
    </div>
  </section>
  
  <!--NIPT------------------->
  <section class="about_clinic"> 
    <!--intro------------------->
    <div class="skin52_bg">
      <h3>赤ちゃんにもお母さんにも<br class="SP">
        負担の少ない出生前診断NIPT</h3>
      <p> NIPT（新型出生前診断）は2016年より日本でも検査がスタートした診断です。<br>
        お母さんの血液10ml程度を採血するだけで胎児の染色体異常の可能性を調べることが出来る検査です。</p>
      <p>妊娠10週と早い時期に低リスクで検査が出来ることから近年検査を受けるお母さんが増えてきています。</p>
      <div class="box">
        <dl>
          <dt>施術可能院</dt>
          <dd>新宿本院</dd>
        </dl>
      </div>
    </div>
    <div class="nipt_rsv">
      <p>20代30代のプレママが選ぶ</p>
      <h4>出生前診断NIPT</h4>
      <div class="btn"><a href="https://rsv.dazzyclinic.jp/stores/nipt/?stcd=shibuya" target="_blank">予約日を確認する</a></div>
    </div>
  </section>
  
  <!--about------------------->
  <div class="page_arrow"> 
    
    <!--説明------------------->
    <section class="page_about">
      <h3>出生前診断とは？</h3>
      <p>出生前診断は<span class="under">妊娠中に胎児の状態を調べる検査</span>全般のことを言います。大きく[確定診断]・[非確定診断]に分類され、前者は従来から行われていた羊水検査・絨毛検査を指します。</p>
      <p>羊水検査・絨毛検査は100%の感度(検査で「陽性」を検出できる割合)で、確実な判断が出来ますが、300人に1人の割合で流産のリスクがあります(検査が原因か、その他の原因かは調べることが出来ません。また、難しい検査の為対応している病院は限られています)。</p>
      <p>後者の非確定検査は母体血清マーカー検査・コンバインド検査・NT検査等を指しますが、検査感度が80%前後であり、検査結果にばらつきがあったり、医師の習熟度により解釈が異なる等の課題があります。</p>
    </section>
    
    <!--説明------------------->
    <section class="page_about">
      <h3>従来の検査との違い</h3>
      <p>NIPTは出生前診断の分類では[非確定検査]となりますが、下記2点が従来の検査と大きく異なります。</p>
      <div class="nipt_about">
        <h4>赤ちゃん、お母さんへの負担が非常に低い検査です</h4>
        <p>お母さんの血液10mlで検査ができるので、赤ちゃんを傷つけずお母さんへも優しい検査です。</p>
      </div>
      <div class="nipt_about">
        <h4>非常に高い精度の検査です</h4>
        <p>従来の非確定検査に比べると圧倒的な感度となります。また特異度(検査で「陰性」を検出出来る割合)は99.6%～99.9%となっており、結果が「陰性」であれば大きな安心が得られます。</p>
        <table>
          <tr>
            <th></th>
            <th>感度</th>
            <th>特異度</th>
          </tr>
          <tr>
            <th>トリソミー21</th>
            <td>99.90%
            <td>99.80%</td>
          </tr>
          <tr>
            <th>トリソミー18</th>
            <td>97.40%
            <td>99.60%</td>
          </tr>
          <tr>
            <th>トリソミー13</th>
            <td>87.50%
            <td>99.90%</td>
          </tr>
        </table>
        <p class="small">※Verinata Health, Inc. PERFORMANCE METRICSより</p>
      </div>
    </section>
    
    <!--/arrow-------------------> 
  </div>
  
  <!--nayami------------------->
  <section class="nipt_arrow_btm"> 
    
    <!--説明------------------->
    <div class="page_about">
      <h3>NIPTの検査でわかること</h3>
      <p>NIPTの検査では21トリソミー(ダウン症候群)、18トリソミー(エドワーズ症候群)、13トリソミー(パトー症候群)などの染色体異常の疾患の可能性がわかります。その他にもモノソミーX(ターナー症候群)などの性染色体による異常や猫鳴き症候群(5p欠失症候群)のように一部の染色体が欠けることで起こる異常まで、様々な染色体異常の有無がわかります。</p>
      <p>※この検査は全ての染色体疾患をスクリーニングする検査ではありません。検査でわかることは全疾患の一部であることを理解の上、検査を受けるかどうか十分にご検討下さい。</p>
    </div>
    
    <!--説明------------------->
    <div class="page_about">
      <h3>デイジークリニックのNIPT検査</h3>
      <div class="nipt_about">
        <h4>個室対応、待ち時間なし、年齢制限なし</h4>
        <p>完全予約制、個室対応のため、待合室で長時間待たされることはありません。 また、日曜日の検査は女性医師が担当します。 検査申込みに年齢制限はありませんが、20歳未満の方で検査を希望される場合は親権者の同意書が必要となります。</p>
      </div>
      <div class="nipt_about">
        <h4>検査メニューについて</h4>
        <p>当クリニックでは3つの検査メニューを用意しております。</p>
        <table>
          <tr>
            <th>メニュー</th>
            <th>検査内容</th>
            <th>価格</th>
          </tr>
          <tr>
            <th>全染色体＋微小欠失検査</th>
            <td class="left">・1～22染色体<br>
              ・性染色体及び性別判定<br>
              ・微小欠失症候群（5種類)</td>
            <td>¥217,800</td>
          </tr>
          <tr>
            <th>全染色体検査</th>
            <td class="left">・1～22染色体<br>
              ・性染色体及び性別判定</td>
            <td>¥181,500</td>
          </tr>
          <tr>
            <th>基本検査</th>
            <td class="left">・21番染色体、18番染色体、13番染色体<br>
              ・性染色体及び性別判定</td>
            <td>¥145,200</td>
          </tr>
        </table>
        <p class="zeikomi">料金はすべて税込です</p>
      </div>
    </div>
  </section>
  
  <!--price------------------->
  <section class="page_cnts">
    <h2>Support<span>デイジークリニックのサポート</span></h2>
    <div>
      <p>デイジークリニックでは検査提供元渋谷NIPTセンター新宿局と提携し、<br class="PC">
        出来うる限りのサポートを提供しています。</p>
    </div>
  </section>
  
  <!--説明------------------->
  <section class="page_about mgt5">
    <h3>もしも陽性結果が出た場合</h3>
    <p>万一陽性結果が出た場合、下記のサポートをしております。検査結果と共に詳細のご案内を差し上げています。</p>
    <div class="nipt_about">
      <h4>小児科医による無料カウンセリング</h4>
      <p>出生前診断コンサルト小児科医(女性小児科医)による無料カウンセリング(60分)をご案内いたします。</p>
      <div class="bg_box">
        <h4>出生前診断コンサルト小児科医とは？</h4>
        <p>日本小児科学会で2022年に新設された認定資格です。NIPTをはじめとする出生前診断について、検査を受けるかどうかを悩んだり、検査後の不安などについてプレママの相談を幅広く受けることが可能な医師です。染色体疾患等についての診療実績、専門知識を持ち、疾患について詳細な説明を行うだけではなく、もしも陽性だった場合どのような治療、リハビリが行われていくのかなど、生まれてからの生活についての説明も必要に応じて行います。</p>
      </div>
    </div>
    <div class="nipt_about">
      <h4>羊水検査費用の保証</h4>
      <p>羊水検査費用を全額保証いたします。</p>
      <p>※かかりつけ医にて羊水検査を受けられる場合にも保証を致します。<br>
        ※オプション検査は対象外となります。</p>
    </div>
    <div class="nipt_about">
      <h4>オプションサポート</h4>
      <p>詳細は予約確認メールをご覧ください。</p>
      <div class="bg_box">
        <p>・検査前、検査結果に関するお悩みについても出生前診断コンサルト小児科医に相談が可能です。(30分/￥3,300)<br>
          ・現役助産師のマタニティ相談が可能です。パートナーや家族に相談出来ない悩み不安をゆっくりと相談したい方はご活用ください(30分/￥1,500)</p>
      </div>
    </div>
    <div class="nipt_about">
      <h4>情報提供</h4>
      <p>・検査を受けた方にサポートパンフレットをお渡ししています(有益な情報は適時更新)<br>
        ・すぐに回答することが出来ないお問い合わせについては検査会社、医師に確認してご案内しております。また検査を受ける際のご相談については必要に応じ渋谷NIPTセンター新宿局の専任スタッフが直接サポートしております。</p>
    </div>
  </section>
  
  <!--btn------------------->
  <section class="about_clinic">
    <div class="nipt_rsv">
      <p>20代30代のプレママが選ぶ</p>
      <h4>出生前診断NIPT</h4>
      <div class="btn"><a href="https://rsv.dazzyclinic.jp/stores/nipt/?stcd=shibuya" target="_blank">予約日を確認する</a></div>
    </div>
  </section>
  
  <!--link------------------->
  <section class="page_cnts">
    <div class="belta_btn"><a href="https://belta.co.jp/maternity/prenatal_diagnosis/">デイジークリニックNIPT紹介の記事<br>
      <span>from BELTA</span></a></div>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
