<?php
/*
Template Name: リニューアル
*/
?>
<?php get_template_part('header_re'); ?>
<?php if ( wp_is_mobile() ) : ?>
<?php echo do_shortcode('[smartslider3 slider="3"]'); ?>
<?php else: ?>
<?php echo do_shortcode('[smartslider3 slider="2"]'); ?>
<?php endif; ?>

<!--contents------------------->
<div class="cnts"> 
  <!--intro------------------->
  <section class="intro">
    <h2 class="intro_h2">DAZZY CLINIC</h2>
    <p class="intro_txt">みなさまの本来の魅力を大切に、<br>
      喜びを提供するクリニックを目指しています。</p>
    <dl>
      <a href="https://www.dazzyclinic.jp/artmake/">
      <dt>
        <?php
        $fields = scf::get( 't_artmake_img', 1056 );
        echo wp_get_attachment_image( $fields, 'large' );
        ?>
      </dt>
      <dd>
        <p class="tit">Art Make<span>医療アートメイク</span></p>
        <p class="obi">対応医院</p>
        <ul>
          <?php
          $free_item = SCF::get( 't_artmake_cliniclist', 1056 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 't_artmake_clinic_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['t_artmake_clinic_li']; ?></li>
          <?php } } ?>
        </ul>
      </dd>
      </a>
    </dl>
    <dl>
      <a href="https://dazzyclinic.jp/skin/">
      <dt>
        <?php
        $fields = scf::get( 't_skin_img', 1056 );
        echo wp_get_attachment_image( $fields, 'large' );
        ?>
      </dt>
      <dd>
        <p class="tit">Skin<span>美容皮膚科</span></p>
        <p class="obi">対応医院</p>
        <ul>
          <?php
          $free_item = SCF::get( 't_skin_cliniclist', 1056 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 't_skin_clinic_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['t_skin_clinic_li']; ?></li>
          <?php } } ?>
        </ul>
      </dd>
      </a>
    </dl>
    <div class="btn btn_bdr_square"><a href="#othermenu">その他の診療メニューはこちら</a></div>
  </section>
  
  <!--important------------------->
  <section class="important">
    <h4>新型コロナウイルス感染防⽌における<br class="SP">
      対策について</h4>
    <div>
      <p><span>当院の対応</span></p>
      <p>当院では、職員のマスク・⼿袋の着⽤、空気清浄機設置、各設備の消毒の徹底、従業員の健康管理 （検温・⾃覚症状等体調の報告）などを実施しております。</p>
    </div>
    <div>
      <p><span>受診者様へのお願い</span></p>
      <p>ご来院時は施設設置のアルコール消毒液にて⼿指消毒、マスク着⽤のご協⼒をお願いいたします。</p>
    </div>
  </section>
  
  <!--bdr_box------------------->
  <div class="bdr_box"> 
    <!--about------------------->
    <section class="about">
      <h2>About<span>デイジークリニックについて</span></h2>
      <h3>デイジークリニックが選ばれる理由</h3>
      <?php
      $free_item = SCF::get( 'about', 1056 );
      foreach ( $free_item as $fields ) {
        if ( $fields[ 'about_tit' ] !== "" ) {
          ?>
      <dl>
        <dt><?php echo wp_get_attachment_image($fields['about_img'], 'large');?></dt>
        <dd>
          <h4><?php echo $fields['about_tit']; ?></h4>
          <p><?php echo nl2br($fields['about_txt']); ?></p>
        </dd>
      </dl>
      <?php } } ?>
      <div class="btn"><a href="https://www.dazzyclinic.jp/about/">詳しくはこちら</a></div>
    </section>
    
    <!--arrow_box------------------->
    <div class="arrow_box"> 
      <!--artmake------------------->
      <section class="artmake">
        <h2>Art Make<span>医療アートメイク</span></h2>
        <div class="inner">
          <h3>デイジークリニックの<br class="SP">
            アートメイクって？</h3>
          <dl>
            <dt>1.</dt>
            <dd><?php echo $fields = scf::get('artmake_no1', 1056 ); ?></dd>
            <dt>2.</dt>
            <dd><?php echo $fields = scf::get('artmake_no2', 1056 ); ?></dd>
            <dt>3.</dt>
            <dd><?php echo $fields = scf::get('artmake_no3', 1056 ); ?></dd>
          </dl>
          <div class="btn"><a href="https://www.dazzyclinic.jp/artmake/">詳しくはこちら</a></div>
        </div>
      </section>
      <!--/arrow_box--> 
    </div>
    
    <!--artmake_2------------------->
    <section class="artmake_2">
      <h3>選べる5つのメニュー</h3>
      <div class="inner">
        <?php
        $free_item = SCF::get( 'top_menu', 1056 );
        foreach ( $free_item as $fields ) {
          if ( $fields[ 'top_menu_tit' ] !== "" ) {
            ?>
        <div><a href="<?php echo $fields['top_menu_url']; ?>"><?php echo wp_get_attachment_image($fields['top_menu_img'], 'large');?>
          <p><?php echo $fields['top_menu_tit']; ?><span><?php echo $fields['top_menu_subtit']; ?></span></p>
          </a> </div>
        <?php } } ?>
      </div>
    </section>
    <section class="artmake_case">
      <h3>症例のご紹介</h3>
      <ul class="slider02">
        <?php
        $free_item = SCF::get( 'artmake_case', 1056 );
        foreach ( $free_item as $fields ) {
          if ( $fields[ 'artmake_case_name' ] !== "" ) {
            ?>
        <li> <?php echo wp_get_attachment_image($fields['artmake_case_img'], 'large');?>
          <dl>
            <dt>施術内容</dt>
            <dd><?php echo $fields['artmake_case_menu']; ?></dd>
            <dt>施術者</dt>
            <dd><?php echo $fields['artmake_case_name']; ?></dd>
            <dt>価格</dt>
            <dd><?php echo $fields['artmake_case_price']; ?></dd>
          </dl>
        </li>
        <?php } } ?>
      </ul>
      <div class="att">
        <?php $myfield = scf::get('myfield'); if( !empty( $myfield )){ ?>
        <div class="myclass"> <?php echo $myfield; ?> </div>
        <?php } ?>
        <?php $myfield = scf::get('artmake_case_att', 1056); if( !empty( $myfield )){ ?>
        <p> <?php echo nl2br( $myfield ); ?> </p>
        <?php } ?>
        <h6>副作用・リスク</h6>
        <ul>
          <?php
          $free_item = SCF::get( 'artmake_case_att_list', 1056 );
          foreach ( $free_item as $fields ) {
            if ( $fields[ 'artmake_case_att_list_li' ] !== "" ) {
              ?>
          <li><?php echo $fields['artmake_case_att_list_li']; ?></li>
          <?php } } ?>
        </ul>
      </div>
      <!--<div class="btn pink"><a href="#">症例をもっと見る</a></div>--> 
    </section>
    
    <!--instagram------------------->
    <section class="instagram">
      <h2>Instagram<span>インスタグラム</span></h2>
      <div class="btn_ig"><a href="https://www.instagram.com/dazzy_clinic/"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/03/icon_ig.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿">
        <p>@dazzy_clinic<span>デイジークリニック公式</span></p>
        </a></div>
      <div class="inner">
        <p>
          <?php $myfield = scf::get('insta_text' , 1056 ); echo nl2br( $myfield ); ?>
        </p>
      </div>
		<?php echo do_shortcode('[instagram-feed feed=1]'); ?>
    </section>
    
    <!--skinmenu------------------->
    <section class="skinmenu">
      <h2>Skin<span>美容皮膚科</span></h2>
      <div class="inner">
        <?php
        $free_item = SCF::get( 'skin', 1056 );
        foreach ( $free_item as $fields ) {
          if ( $fields[ 'skin_tit' ] !== "" ) {
            ?>
        <dl>
          <a href="<?php echo $fields['skin_url']; ?>">
          <dt> <?php echo wp_get_attachment_image($fields['skin_img'], 'large');?>
            <p><?php echo $fields['skin_tit']; ?><span><?php echo $fields['skin_about']; ?></span></p>
          </dt>
          <dd>
            <ul>
              <?php echo $fields['skin_clinic']; ?>
            </ul>
          </dd>
          </a>
        </dl>
        <?php } } ?>
      </div>
      <div class="btn"><a href="https://dazzyclinic.jp/skin/">詳しくはこちら</a></div>
    </section>
    
    <!--othermenu------------------->
    <section class="othermenu" id="othermenu">
      <h2>Other Menu<span>その他のメニュー</span></h2>
      <?php
      $free_item = SCF::get( 'other', 1056 );
      foreach ( $free_item as $fields ) {
        if ( $fields[ 'other_tit' ] !== "" ) {
          ?>
      <dl>
        <dt><?php echo wp_get_attachment_image($fields['other_img'], 'large');?>
          <p><span><?php echo $fields['other_subtit']; ?></span><?php echo $fields['other_tit']; ?></p>
        </dt>
        <dd><?php echo nl2br($fields['other_text']); ?>
          <div class="btn"><a href="<?php echo $fields['other_url']; ?>">詳しくはこちら</a></div>
        </dd>
      </dl>
      <?php } } ?>
    </section>
    
    <!--/bdr_box--> 
  </div>
  
  <!--skinmenu------------------->
  <section class="faq">
    <h2>FAQ<span>よくある質問</span></h2>
    <?php
    $free_item = SCF::get( 'faq', 1056 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'faq_q' ] !== "" ) {
        ?>
    <dl>
      <dt class="faq_tit js_tit">
        <p><?php echo $fields['faq_q']; ?></p>
      </dt>
      <dd class="faq_content">
        <p><?php echo nl2br($fields['faq_a']); ?></p>
        <?php if($fields['faq_link']):?>
        <div class="btn"><a href="<?php echo $fields['faq_url']; ?>"><?php echo $fields['faq_link']; ?></a></div>
        <?php endif;?>
      </dd>
    </dl>
    <?php } } ?>
    <div class="btn"><a href="https://www.dazzyclinic.jp/faq/">その他のよくある質問</a></div>
  </section>
  
  <!--news------------------->
  <section class="news">
    <h2>News<span>デイジークリニックからのお知らせ</span></h2>
    <div class="inner">
      <?php
      $free_item = SCF::get( 'news', 1056 );
      foreach ( $free_item as $fields ) {
        if ( $fields[ 'news_date' ] !== "" ) {
          ?>
      <dl>
        <dt><?php echo $fields['news_date']; ?><span class="<?php echo $fields['news_check']; ?>"></span></dt>
        <dd>
          <p><?php echo $fields['news_text']; ?></p>
          <?php if($fields['news_link_url']):?>
          <p><a href="<?php echo $fields['news_link_url']; ?>"><?php echo $fields['news_link_text']; ?></a></p>
          <?php endif;?>
        </dd>
      </dl>
      <?php } } ?>
    </div>
  </section>
  
  <!--cliniclist------------------->
  <section class="cliniclist">
    <h2>Clinic List<span>医院紹介</span></h2>
    <?php
    $free_item = SCF::get( 'clinic', 1056 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'clinic_name' ] !== "" ) {
        ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['clinic_img'], 'large');?>
        <ul>
          <?php echo $fields['clinic_menu']; ?>
        </ul>
        <div>
          <h3><?php echo $fields['clinic_name']; ?></h3>
          <a href="<?php echo $fields['clinic_map']; ?>">MAP</a></div>
      </dt>
      <dd>
        <p><?php echo nl2br($fields['clinic_text']); ?></p>
        <div class="time">診療時間: <?php echo $fields['clinic_time']; ?></div>
        <div class="btn"><a href="<?php echo $fields['clinic_url']; ?>">詳しくはこちら</a></div>
      </dd>
    </dl>
    <?php } } ?>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_template_part('footer_re'); ?>
