<?php
/*
Template Name: skin52
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_skin52"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--about_clnic------------------->
  <section class="about_clinic">
    <h2>Skin52<span>傷跡修正</span></h2>
    <div class="skin52_bg">
      <h3> 最新医療アートメイク<br class="SP">
        ×<br class="SP">
        AI搭載技術 </h3>
      <p> 95％以上のスキントーンマッチングにより、<br>
        妊娠線や傷跡を綺麗に目立たなくすることが可能です。 </p>
      <div class="box">
        <dl>
          <dt>施術可能院</dt>
          <dd>心斎橋院</dd>
        </dl>
      </div>
    </div>
  </section>
  
  <!--arrow------------------->
  <div class="page_arrow"> 
    
    <!--説明------------------->
    <section class="page_about">
      <h3>Skin52(傷跡修正)とは？</h3>
      <p>Skin52とは、美容医療の先進国と言われる韓国から導⼊された、新しい医療アートメイクとして注目されている技術です。⾊素を注⼊し周りの肌との⾊味を馴染ませることで、ストレッチマーク(⾁割れ・妊娠線)や傷跡、⽩斑などを目立たなくすることができます。<br>
        完治・消去する治療ではありませんが、周りのお肌と馴染ませることにより、色ムラが目立ちにくくなります。<br>
        ※傷跡の経過時間や状態によって施術ができない場合があるため、必ず施術前に適応可能か判断をさせていただいております。 </p>
    </section>
    
    <!--説明------------------->
    <section class="page_about skin52">
      <h3>このようなお悩みをお持ちの方に</h3>
      <ul class="check">
        <li>妊娠線が目立つ</li>
        <li>⾁割れがある</li>
        <li>レーザー治療を受けても効果が得られなかった</li>
        <li>事故やケガ、⼿術跡が気になる</li>
        <li>リストカットの痕を消したい</li>
        <li>白斑（白抜け）が目立つ</li>
        <li>傷跡を消したい</li>
      </ul>
    </section>
    
    <!--/arrow-------------------> 
  </div>
  
  <!--nayami------------------->
  <section class="page_arrow_btm skin52_yuko">
    <h3>Skin52が有効な傷跡</h3>
    <ul>
      <li><a href="#stretchmark"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/stretchmark_maru.webp" alt="ストレッチマーク">
        <p>ストレッチマーク</p>
        </a></li>
      <li><a href="#kizuato"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/kizuato.webp" alt="瘢痕">
        <p>瘢痕</p>
        </a></li>
      <li><a href="#hakuhan"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/hakuhan.webp" alt="白斑">
        <p>白斑</p>
        </a></li>
      <li><a href="#wristcut"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/wristcut.webp" alt="リストカット跡">
        <p>リストカット跡</p>
        </a></li>
    </ul>
  </section>
  
  <!--case------------------->
  <section class="page_cnts">
    <h2>Case<span>症例のご紹介</span></h2>
    
    <!---->
    <div class="skin52_case" id="stretchmark">
      <div class="inner">
        <h3>ストレッチマーク</h3>
        <p>ストレッチマークとは、肉割れや妊娠線を指します。妊娠や過剰な筋トレなどの急激な⾝体の変化によってコラーゲン繊維が裂け、肌の表⾯にひび割れのような⻲裂ができた状態です。表皮は柔らかく柔軟性がある組織ですが、真皮はしっかりした組織で柔軟性がありません。急激な体重増加などによって、皮膚が引っ張られたとき、表皮は伸びて対応するのですが、真皮は伸びることができずに裂けてしまうのです。</p>
        <div class="box">
          <h4>妊娠線・肉割れ出現のメカニズム</h4>
          <p><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/stretchmark.webp" alt="ストレッチマーク" class="PC"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/stretchmark_sp.webp" alt="ストレッチマーク" class="SP"></p>
        </div>
        <p>できたばかりのストレッチマークは⾚紫色をしており、この段階ではレーザー治療が可能ですが、時間が経つにつれ白っぽく変化していきます。白く変化したストレッチマークを治療する⽅法はないとされています。</p>
        <div class="box">
          <h4>ストレッチマークができやすい場所</h4>
          <p><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/stretchmark2.webp" alt="ストレッチマーク" class="PC"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/stretchmark_sp2.webp" alt="ストレッチマーク" class="SP"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/stretchmark_sp3.webp" alt="ストレッチマーク" class="SP"></p>
        </div>
      </div>
    </div>
    
    <!---->
    <div class="skin52_case" id="kizuato">
      <div class="inner">
        <h3>瘢痕<span>（やけど・けがの跡・手術の切開後）</span></h3>
        <p>手術やケガ、やけどの白っぽく残った跡もSkin52によって目立たなくすることができます。傷跡が盛り上がってしまうケロイドをへこませたり、なくす効果はないものの、肌に馴染ませる効果は期待できます。<br>
          ※炎症が起きている傷、ケロイドの傷跡や6カ⽉経過していない傷跡には施術ができません。</p>
        <div class="box pink">
          <h4>瘢痕の例</h4>
          <div class="flex">
            <dl>
              <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/kizuato.webp" alt="瘢痕"></dt>
              <dd>やけどやケガの跡</dd>
            </dl>
            <dl>
              <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/kizuato2.webp" alt="瘢痕"></dt>
              <dd>手術跡</dd>
            </dl>
          </div>
        </div>
      </div>
    </div>
    
    <!---->
    <div class="skin52_case" id="hakuhan">
      <div class="inner">
        <h3>白斑</h3>
        <p>皮膚の一部分の色素が抜けてしまったように見える症状に悩む方も多いです。これは、⾊素の素である「メラニン」を生成するメラノサイト(⾊素細胞)が何らかの原因で減少・消失する後天性の病気で、名称を尋常性白斑（じんじょうせいはくはん）と言います。<br>
          原因ははっきりとわかっておらず、遺伝的な要因が関連しているのではないかと推測されています。その他、ストレス・外傷・⽇焼けなどが補助的に作⽤することもあります。 </p>
        <div class="box">
          <h4>施術のイメージ</h4>
          <p><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/hakuhan2.webp" alt="白斑" class="PC"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/hakuhansp.webp" alt="白斑" class="SP"></p>
        </div>
        <p> ※⽩斑症の場合、施術の刺激により追加拡散範囲が生じる場合があります。そのため、主治医事前に相談していただき、許可を得てからのご来院をお願いいたします。 </p>
      </div>
    </div>
    
    <!---->
    <div class="skin52_case" id="wristcut">
      <div class="inner">
        <h3>リストカット跡</h3>
        <p>リスカ跡のために人の目が気になり、長袖しか着られない、服装を選ばなければならないという方も少なくありません。このリスカ跡にも、「アートメイクSkin52」は非常に有効です。<br>
          ※炎症が起きている場合、ケロイドの傷跡や6ヶ月経過していない傷跡には施術ができません。</p>
        <div class="box">
          <h4>施術のイメージ</h4>
          <p><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/wristcut2.png" alt="リストカット跡" class="PC"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/09/wristcut_sp.png" alt="リストカット跡" class="SP"></p>
        </div>
      </div>
    </div>
  </section>
  
  <!--support------------------->
  <section class="page_support">
    <h2>About<span>Skin52の特徴</span></h2>
    <?php $free_item = SCF::get( 'support', 1785 ); foreach ( $free_item as $fields ) { ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['support_img'], 'large');?></dt>
      <dd>
        <p class="tit"><span class="step"><?php echo $fields['support_no']; ?></span><?php echo $fields['support_tit']; ?></p>
        <?php echo nl2br( $fields['support_txt'] ); ?>
    </dl>
    <?php } ?>
  </section>
  
  <!--payment------------------->
  <section class="page_price">
    <h2>Price<span>料金のご案内</span></h2>
    <h3>医療アートメイク Skin52</h3>
    <?php echo do_shortcode('[table id=19 /]'); ?>
    <p class="zeikomi" style="margin-bottom: 3em;">料金はすべて税込です<br>※2回施術メニューの2回目施術期限は、2ヶ月以内にお願いしております</p>
    <div class="payment_box">
      <p class="top">お⽀払いは、「現金一括払い」「クレジットカード」「QRコード決済」「電子マネー」「交通系IC各種」のいずれかよりお選びいただけます。</p>
      <span>現金一括払い</span> <span>クレジットカード</span>
      <ul class="icon">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/visa.webp" alt="VISA"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/mastercard.webp" alt="MasterCard"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/jcb.webp" alt="JCB"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/amex.webp" alt="AMERICAN EXPRESS"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/dinersclub.webp" alt="Diners Club"></li>
      </ul>
      <p>VISA / MasterCard / JCB / AMERICAN EXPRESS / Diners Club</p>
      <!----> 
      <span>QR決済</span>
      <ul class="icon">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/dbarai.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/rpay.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/yutyo.webp" alt=""></li>
      </ul>
      <p>各種QR決済</p>
      <!--ohter--> 
      <span>電子マネー</span>
      <ul class="icon">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/id.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/waon.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/nanaco.webp" alt=""></li>
      </ul>
      <p>各種電子マネー</p>
      <span>交通系IC各種</span>
      <ul class="icon icon_img">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/ic.webp" alt="交通系IC各種"></li>
      </ul>
      <p>各種交通系IC各種</p>
    </div>
    <div class="counseling">
      <h4>＼無料LINE相談受付中／</h4>
      <p>実際に施術ができる肌の状態かの確認や、<br>
        サイズに合わせた費用の見積もりなどアーティストがお答えします。<br>
        お気軽にご相談くださいませ。</p>
      <div class="btn"><a href="https://lin.ee/wGSzzSx" target="_blank">無料LINE相談はこちら</a></div>
    </div>
  </section>
  
  <!--guide------------------->
  <section class="page_guide skin52_top_bdr">
    <h2>Guide<span>治療についてのご案内</span></h2>
    <dl>
      <?php
      $free_item = SCF::get( 'guide_dl', 1785 );
      foreach ( $free_item as $fields ) {
        if ( $fields[ 'guide_dt' ] !== "" ) {
          ?>
      <dt> <?php echo $fields['guide_dt']; ?> </dt>
      <dd> <?php echo nl2br($fields['guide_dd']); ?> </dd>
      <?php } } ?>
    </dl>
  </section>
  
  <!--faq------------------->
  <section class="faq page_faq">
    <h2>FAQ<span>よくある質問</span></h2>
    <?php
    $free_item = SCF::get( 'page_faq', 1785 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'page_faq_q' ] !== "" ) {
        ?>
    <dl>
      <dt class="faq_tit js_tit">
        <p><?php echo $fields['page_faq_q']; ?></p>
      </dt>
      <dd class="faq_content">
        <p><?php echo nl2br($fields['page_faq_a']); ?></p>
      </dd>
    </dl>
    <?php } } ?>
    <div class="btn"><a href="https://www.dazzyclinic.jp/faq/">その他のよくある質問</a></div>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
