<?php
/*
Template Name: テスト
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_daisy"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--pill------------------->
  <section class="page_cnts">
    <h2>Pill<span>低用量ピル(オンライン診療)</span></h2>
  </section>
  
  <!--nayami------------------->
  <section class="page_cnts nayami nayami_bg">
    <h2>"⾃宅にピルが届く"私の新習慣</h2>
    <p class="point_top">デイジークリニックのピル処方は</p>
    <div class="point3">
      <p>低価格</p>
      <span>×</span>
      <p>安心</p>
      <span>×</span>
      <p>手軽</p>
    </div>
    <p class="point_btm">だから続けられる</p>
  </section>
  
  <!--arrow------------------->
  <div class="page_arrow"> 
    
    <!--説明------------------->
    <section class="page_about">
      <h3>低⽤量ピルとは？</h3>
      <p>低⽤量ピルには⼥性ホルモンが含まれており、毎⽇1回服⽤することで排卵を抑制し、正しく服⽤すればほぼ確実に避妊することが可能です。<br>
        ⽇本では低⽤量ピルの使⽤率は1〜3％に留まりますが、欧⽶では⼀般的に使用されている薬剤です。<br>
        近年、日本でもリスクをきちんと理解し、低用量ピルを服用される⽅が増えています。</p>
    </section>
    
    <!--説明------------------->
    <section class="page_about">
      <h3>低⽤量ピルの効果</h3>
      <p>低⽤量ピルは、⼥性のさまざまな悩みに対してプラスに働く効果が多数存在しています。</p>
      <div class="check">
        <h4>さまざまな効果が期待できます</h4>
        <ul>
          <li><span>避妊</span></li>
          <li><span>PMSの改善</span></li>
          <li><span>ニキビの改善</span></li>
          <li><span>⽣理痛や⽣理不順の改善</span></li>
          <li><span>⼦宮内膜症の改善</span></li>
        </ul>
      </div>
    </section>
    
    <!--説明------------------->
    <section class="page_about">
      <h3>薬の種類と違い</h3>
      <p>デイジークリニックでは、国内正規品の「マーベロン」と「トリキュラー」の2種類の薬剤を取り扱っています。</p>
      <?php $free_item = SCF::get( 'pill_box', 176 ); foreach ( $free_item as $fields ) { ?>
      <dl>
        <dt>
          <h4><?php echo $fields['pill_name']; ?></h4>
          <?php echo wp_get_attachment_image($fields['pill_img'], 'large');?></dt>
        <dd>
          <p class="text"><?php echo nl2br( $fields['pill_txt'] ); ?></p>
          <p class="price"><?php echo $fields['pill_price']; ?>(税込)</p>
        </dd>
      </dl>
      <?php } ?>
    </section>
    
    <!--説明------------------->
    <section class="page_about">
      <h3>副作用について</h3>
      <p> 主に、内服開始当初（ピルにまだ慣れていない時期）に吐き気・不正出⾎等の症状が出現することがありますが、多くの⽅は内服を継続することで改善していきます。これらの症状については、過度な⼼配は必要ありません。<br>
        <span class="under">吐き気</span>、<span class="under">頭痛</span>、<span class="under">乳房の張りなどの不快感</span>、<span class="under">むくみ</span>（これが「低⽤量ピル＝太る」という誤解の原因）のほか、重篤なものに、<span class="under">⾎栓症</span>があります。<br>
        年間10,000⼈に対して3〜9⼈と、割合としてみれば少ないですが、<span class="under">⾎栓傾向のある⽅にはおすすめはしません。</span></p>
    </section>
    
    <!--説明------------------->
    <section class="page_about last">
      <h3>服⽤⽅法</h3>
      <p>⽣理の第1⽇⽬から1⽇1回1錠を28⽇間連続でなるべく決まった時間に内服してください。<br>
        低⽤量ピルは21⽇間服⽤し7⽇間休薬することで効果を発揮します。<br>
        <br>
        デイジークリニックは28錠タイプのものを扱っており、実薬が21錠、残りの7錠が偽薬で、毎⽇内服すれば、⾃然と21⽇間の服⽤と7⽇間の休薬が続けられる優れものです。</p>
    </section>
    
    <!--/arrow--> 
  </div>
  
  <!--nayami------------------->
  <section class="page_arrow_btm">
    <div class="inner">
      <h2><span class="small">毎⽇規則正しく内服することで</span><span class="pink">約99％</span>の⾼い効果が<br>
        報告されています！</h2>
      <p>継続的に内服していけるように、<br class="SP">
        定期配送もおすすめしています。<br>
        飲み忘れにはご注意ください。</p>
    </div>
  </section>
  
  <!--support------------------->
  <section class="page_support">
    <h2>About<span>デジクリのオンラインピル処方</span></h2>
    <?php $free_item = SCF::get( 'support', 176 ); foreach ( $free_item as $fields ) { ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['support_img'], 'large');?></dt>
      <dd>
        <p class="tit"><span class="step"><?php echo $fields['support_no']; ?></span><?php echo $fields['support_tit']; ?></p>
        <?php echo nl2br( $fields['support_txt'] ); ?>
    </dl>
    <?php } ?>
  </section>
  
  <!--payment------------------->
  <section class="page_cnts">
    <h2>Payment<span>お支払い方法について</span></h2>
    <p>お薬代(1カ月)</p>
    <div class="pay_price_box">
      <dl>
        <?php $free_item = SCF::get( 'pill_box', 176 ); foreach ( $free_item as $fields ) { ?>
        <dt><?php echo $fields['pill_name']; ?></dt>
        <dd><?php echo $fields['pill_price']; ?>(税込)</dd>
        <?php } ?>
      </dl>
      <p>※送料・診察料はすべてお薬代に含まれています。</p>
    </div>
    <div class="payment_box">
      <p class="top">
        <?php $myfield = scf::get_option_meta( 'theme-options', 'payment' ); echo nl2br( $myfield ); ?>
      </p>
      <span>クレジットカード</span>
      <ul class="icon">
        <?php $free_item = SCF::get_option_meta( 'theme-options', 'credit_icon' ); foreach ( $free_item as $fields ) { ?>
        <li><?php echo wp_get_attachment_image($fields['credit_icon_li'], 'large');?></li>
        <?php } ?>
      </ul>
      <p>
        <?php $myfield = scf::get_option_meta( 'theme-options', 'credit_txt' ); echo nl2br( $myfield ); ?>
      </p>
      <!----> 
      <span>QR決済</span>
      <ul class="icon">
        <?php $free_item = SCF::get_option_meta( 'theme-options', 'qr_icon' ); foreach ( $free_item as $fields ) { ?>
        <li><?php echo wp_get_attachment_image($fields['qr_icon_li'], 'large');?></li>
        <?php } ?>
      </ul>
      <p>
        <?php $myfield = scf::get_option_meta( 'theme-options', 'qr_txt' ); echo nl2br( $myfield ); ?>
      </p>
      <!--ohter-->
      <?php $free_item = SCF::get_option_meta( 'theme-options', 'pay_other' ); foreach ( $free_item as $fields ) { ?>
      <span><?php echo $fields['pay_other_li']; ?></span>
      <?php } ?>
      </ul>
    </div>
    <div class="counseling">
      <h4>無料カウンセリングはこちら</h4>
      <p>お気軽にお申込みください。</p>
      <div class="btn"><a href="https://rsv.dazzyclinic.jp/stores/pill/" target="_blank">ご予約フォームへ進む</a></div>
    </div>
  </section>
  
  <!--page_howto------------------->
  <section class="page_howto">
    <h2>How To<span>施術の流れ</span></h2>
    <?php $free_item = SCF::get( 'page_howto', 176 ); foreach ( $free_item as $fields ) { ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['page_howto_img'], 'large');?></dt>
      <dd>
        <p class="step"><?php echo $fields['page_howto_step']; ?></p>
        <?php if($fields['page_howto_time']):?>
        <p class="time"><?php echo wp_kses_post( $fields['page_howto_time'] ); ?></p>
        <?php endif;?>
        <p class="tit"><?php echo $fields['page_howto_tit']; ?></p>
        <?php echo nl2br( $fields['page_howto_txt'] ); ?>
    </dl>
    <?php } ?>
  </section>
  
  <!--price------------------->
  <section class="page_price">
    <h2>Price<span>料金のご案内</span></h2>
    <h3>低⽤量ピル(送料・診察料込)</h3>
    <?php echo do_shortcode('[table id=9 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
  </section>
  
  <!--faq------------------->
  <section class="faq page_faq">
    <h2>FAQ<span>よくある質問</span></h2>
    <?php
    $free_item = SCF::get( 'page_faq', 176 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'page_faq_q' ] !== "" ) {
        ?>
    <dl>
      <dt class="faq_tit js_tit">
        <p><?php echo $fields['page_faq_q']; ?></p>
      </dt>
      <dd class="faq_content">
        <p><?php echo nl2br($fields['page_faq_a']); ?></p>
      </dd>
    </dl>
    <?php } } ?>
    <div class="btn"><a href="https://www.dazzyclinic.jp/faq/">その他のよくある質問</a></div>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
