<?php
/*
Template Name: クリニック詳細
Template Post Type: cdetail
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_clinic"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--pill------------------->
  <section class="page_cnts">
    <h2>Clinic<span>
      <?php $myfield = scf::get('clinic_name'); echo $myfield; ?>
      </span></h2>
  </section>
  
  <!--banner------------------->
  
  <?php if ( is_single( array ( 'テスト' )) ) : ?>
  <section class="banner">
    <div><a href="https://www.dazzyclinic.jp/holiday2022_osaka/"><img src="https://www.dazzyclinic.jp/wp-content/themes/dazzyclinic/holiday2022/banner_osaka.jpg"></a></div>
  </section>
  <?php endif; ?>
  <?php if ( is_single( array ( 'テスト' )) ) : ?>
  <section class="banner">
    <div><a href="https://www.dazzyclinic.jp/holiday2022_fukuoka/"><img src="https://www.dazzyclinic.jp/wp-content/themes/dazzyclinic/holiday2022/banner_fukuoka.jpg"></a></div>
  </section>
  <?php endif; ?>
  
  <!--nayami------------------->
  <section class="page_clinic">
    <dl class="base">
      <dt>
        <?php
        $myfield = scf::get( 'clinic_img' );
        echo wp_get_attachment_image( $myfield, 'large' );
        ?>
      </dt>
      <dd> 
        
        <!------------------>
        <?php if ( is_single( array ( 'fukuoka_skin' )) ) : ?>
        <div class="info">
          <p><span class="bold red">福岡院名称変更のお知らせ</span></p>
          <p>デイジースキンクリニック福岡院は2023年9月よりブランド変更を致します。<br>
            医院場所、院内スタッフ等、大きな変更はございません。<br>
            今後ともご愛顧を賜りますよう、よろしくお願い申し上げます。</p>
          <p><span class="bold">RENATA CLINIC 福岡院</span><br>
            <a href="https://www.renataclinic.com/">https://www.renataclinic.com/</a></p>
        </div>
        <?php endif; ?>
        
        <!------------------>
        <?php
        /*
        <?php if ( is_single( array ( 'osaka' )) ) : ?>
        <div class="info">
          <p><span class="bold red">年末年始のお知らせ</span></p>
          <p class="red" style="margin-top: 0;"> 年末は12/30(土)が最終診察日となります。<br>
            12/31(日)-1/3(水)は休診いたします。<br>
            年始は1/4(木)から診察開始いたします。何卒よろしくお願いいたします。</p>
        </div>
        <?php endif; ?>
		*/
        ?>
        
        <!--clinic info------------------->
        <ul class="tag">
          <?php $term = scf::get('clinic_tag'); foreach ($term as $field) { echo "<li>", get_the_category_by_ID($field) , "</li>"; } ?>
        </ul>
        <h4>
          <?php $myfield = scf::get('clinic_name'); echo $myfield; ?>
        </h4>
        <dl>
          <dt>診療時間</dt>
          <dd>
            <?php $myfield = scf::get('clinic_time'); echo nl2br( $myfield ); ?>
          </dd>
          <dt>休診日</dt>
          <dd>
            <?php $myfield = scf::get('clinic_holiday'); echo nl2br( $myfield ); ?>
          </dd>
          <dt>住所</dt>
          <dd>
            <?php $myfield = scf::get('clinic_add'); echo nl2br( $myfield ); ?>
            <a href="<?php $myfield = scf::get('clinic_map_link'); echo $myfield; ?>" class="map_btn">MAP</a>
            <?php if ( is_single( array ( 'fukuoka_skin' )) ) : ?>
            <p><span>アートメイクは5階</span>です。お間違えやすいのでご留意ください。</p>
            <?php endif; ?>
            <?php if ( is_single( array ( 'osaka' )) ) : ?>
            <p><span>アートメイクは5階</span>です。お間違えやすいのでご留意ください。</p>
            <?php endif; ?>
          </dd>
          <dt>最寄り駅</dt>
          <dd>
            <?php $myfield = scf::get('clinic_station'); echo nl2br( $myfield ); ?>
          </dd>
          <?php if ( is_single( array ( 'osaka' )) ) : ?>
          <?php $myfield = scf::get('clinic_tel'); if( !empty( $myfield )){ ?>
          <dt>電話番号</dt>
          <dd> 【美容皮膚科専用TEL】<br class="SP">
            <a href="tel:<?php $myfield = scf::get('clinic_tel'); echo ( $myfield ); ?>">
            <?php $myfield = scf::get('clinic_tel'); echo ( $myfield ); ?>
            </a><br>
            【アートメイク専用TEL】<br class="SP">
            <a href="tel:<?php $myfield = scf::get('clinic_tel2'); echo ( $myfield ); ?>">
            <?php $myfield = scf::get('clinic_tel2'); echo ( $myfield ); ?>
            </a></dd>
          <?php } ?>
          <?php else:?>
          <?php $myfield = scf::get('clinic_tel'); if( !empty( $myfield )){ ?>
          <dt>電話番号</dt>
          <dd> <a href="tel:<?php echo $myfield; ?>"><?php echo $myfield; ?></a></dd>
          <?php } ?>
          <?php endif; ?>
          <dt>SNS</dt>
          <dd class="clinic_sns">
            <?php $myfield = scf::get('clinic_instagram'); if( !empty( $myfield )){ ?>
            <div> <a href="<?php echo $myfield; ?>"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/03/icon_ig.png"></a> </div>
            <?php } ?>
            <?php $myfield = scf::get('clinic_tiktok'); if( !empty( $myfield )){ ?>
            <div> <a href="<?php echo $myfield; ?>"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/tiktok.png"></a> </div>
            <?php } ?>
          </dd>
        </dl>
        
        <!--banner------------------->
        <?php
        /*
               <?php if ( is_single( array ( 'osaka' )) ) : ?>
               <div class="menu_link">
                 <h3>医療アートメイクのご予約</h3>
                 <div class="inner">
                   <ul>
                     <li><a href="https://reservation.medical-force.com/c/5e64601b249749ca90359568a89adcc8/reservations/new?menu_entrance_id=6c00ae2f-a4fa-4634-a8f9-5f870991c92e">眉・リップはこちら</a></li>
                     <li><a href="https://lin.ee/wGSzzSx">傷跡・頭皮はこちら</a></li>
                   </ul>
                 </div>
               </div>
               <?php else:?>
               <?php endif; ?> */
        ?>
        
        <!--banner------------------->
        <?php if ( is_single( array ( 'osaka' )) ) : ?>
        <ul class="cambana">
          <li><a href="https://dazzyskinclinic.jp/lp/osk_campaign/"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/07/20230721_DAZZY_HPバナー1.jpg"></a></li>
          <li><a href="https://dazzyskinclinic.jp/lp/osa_potenza01/"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/07/20230721_DAZZY_HPバナー3.jpg"></a></li>
          <li><a href="https://dazzyskinclinic.jp/lp/osk_skin5201/"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/07/20230721_修正_DAZZY_HPバナー4.jpg"></a></li>
          <li><a href="https://reservation.medical-force.com/c/5e64601b249749ca90359568a89adcc8?_ga=2.266907719.897681215.1689921631-127391879.1681875151&_gl=1*5ii672*_ga*MTI3MzkxODc5LjE2ODE4NzUxNTE.*_ga_L81PQL7EML*MTY4OTkyODIyMC4xNzAuMS4xNjg5OTI5OTYwLjYwLjAuMA.."><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/07/20230721_DAZZY_HPバナー2.jpg"></a></li>
        </ul>
        <?php else:?>
        <?php endif; ?>
        
        <!--menu------------------->
        <div class="menu_link">
          <h3>取り扱いメニュー</h3>
          <div class="inner">
            <?php $mycheck = scf::get('menu_artmake'); if( $mycheck ){ ?>
            <h4>医療アートメイク</h4>
            <ul>
              <?php
              $myfield = scf::get( 'menu_artmake' );
              foreach ( $myfield as $field ) {
                if ( $field == 'アートメイク' ) {
                  echo '<li><a href="https://www.dazzyclinic.jp/artmake/">医療アートメイク</a></li>';
                } elseif ( $field == 'Skin52' ) {
                  echo '<li><a href="https://www.dazzyclinic.jp/skin52/">Skin52(傷跡修正)</a></li>';
                }
              }
              ?>
            </ul>
            <?php } ?>
            <?php $mycheck = scf::get('menu_shinryo'); if( $mycheck ){ ?>
            <h4>診療メニュー</h4>
            <ul>
              <?php
              $myfield = scf::get( 'menu_shinryo' );
              foreach ( $myfield as $field ) {
                if ( $field == 'ピル' ) {
                  echo '<li><a href="https://www.dazzyclinic.jp/pill/">低用量ピル</a></li>';
                } elseif ( $field == 'GLP-1' ) {
                  echo '<li><a href="https://www.dazzyclinic.jp/glp1/">GLP-1</a></li>';
                }
                elseif ( $field == 'NIPT' ) {
                  echo '<li><a href="https://www.dazzyclinic.jp/cnts/clinic/NIPT.html#sunset">NIPT</a></li>';
                }
                elseif ( $field == '点滴' ) {
                  echo '<li><a href="#tenteki">点滴</a></li>';
                }
                elseif ( $field == '注射' ) {
                  echo '<li><a href="https://www.dazzyclinic.jp/#othermenu">注射</a></li>';
                }
              }
              ?>
            </ul>
            <?php } ?>
            <?php $mycheck = scf::get('menu_skin'); if( $mycheck ){ ?>
            <h4>美容皮膚科</h4>
            <ul>
              <?php
              $myfield = scf::get( 'menu_skin' );
              foreach ( $myfield as $field ) {
                if ( $field == 'ダーマペン4' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/dermapen/">ダーマペン4</a></li>';
                } elseif ( $field == 'アクネフォト' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/acnephoto/">アクネフォト</a></li>';
                }
                elseif ( $field == 'HIFU' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/hifu/">HIFU</a></li>';
                }
                elseif ( $field == 'ピコレーザー' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/pico/">ピコレーザー</a></li>';
                }
                elseif ( $field == 'ケアシス' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/caresys/">ケアシス</a></li>';
                }
                elseif ( $field == 'フォトフェイシャル(ステラM22)' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/stellam22/">フォトフェイシャル(ステラM22)</a></li>';
                }
                elseif ( $field == 'ハイドラフェイシャル' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/hydrafacial/">ハイドラフェイシャル</a></li>';
                }
                elseif ( $field == 'ミラノリピール' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/milano_repeel/">ミラノリピール</a></li>';
                }
                elseif ( $field == 'マッサージピール' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/massagepeel/">マッサージピール</a></li>';
                }
                elseif ( $field == 'メソガン' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/mesogun/">メソガン</a></li>';
                }
                elseif ( $field == 'NMN点滴療法' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/nmn/">NMN点滴療法</a></li>';
                }
                elseif ( $field == '高濃度ビタミンC点滴' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/vitamincivdrip/">高濃度ビタミンC点滴</a></li>';
                }
                elseif ( $field == 'ボトックス注射' ) {
                  echo '<li><a href="#hifuka-price">ボトックス注射</a></li>';
                }
                elseif ( $field == 'ヒアルロン酸注入治療' ) {
                  echo '<li><a href="https://dazzyclinic.jp/skin/menu/hyaluronic/">ヒアルロン酸注入治療</a></li>';
                }
                elseif ( $field == '医療脱毛（女性）' ) {
                  echo '<li><a href="#datumo">医療脱毛（女性）</a></li>';
                }
                elseif ( $field == '医療脱毛（男性）' ) {
                  echo '<li><a href="#datumo">医療脱毛（男性）</a></li>';
                }
                elseif ( $field == '都度脱毛（女性）' ) {
                  echo '<li><a href="#datumo">都度脱毛（女性）</a></li>';
                }
                elseif ( $field == '都度脱毛（男性）' ) {
                  echo '<li><a href="#datumo">都度脱毛（男性）</a></li>';
                }
              }
              ?>
            </ul>
            <?php } ?>
            <?php if ( is_single( array ( 'osaka' , 'テスト' )) ) : ?>
            <div class="btn" style="margin-bottom: 1em"><a href="https://dazzyclinic.jp/skin/pricelist/#tabs-osaka">美容皮膚科の料金表はこちら</a></div>
            <?php endif; ?>
          </div>
        </div>
      </dd>
    </dl>
  </section>
  
  <!--price------------------->
  <section class="page_price" id="price">
    <h2>Price<span>料金のご案内</span></h2>
    
    <!--アートメイク--> 
    
    <!--アートメイク(札幌)-->
    <?php if ( is_single( array ( 'sapporo' )) ) : ?>
    <h3 class="line">アートメイク</h3>
    <h3>2回セット価格(税込)</h3>
    <?php echo do_shortcode('[table id=30 /]'); ?>
    <h3>1回コース</h3>
    <?php echo do_shortcode('[table id=55 /]'); ?>
    <h3>指名料</h3>
    <?php echo do_shortcode('[table id=29 /]'); ?>
    <div class="trainee">
      <p>過去アートありの方はプレミアムランクとマスターランクのみご案内となります。</p>
    </div>
    <?php $myfield = scf::get('trainee_tit'); if( !empty( $myfield )){ ?>
    <div class="trainee">
      <h4>
        <?php $myfield = scf::get('trainee_tit'); echo $myfield; ?>
      </h4>
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <?php } ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--アートメイク(福岡)-->
    <?php if ( is_single( array ( 'fukuoka' )) ) : ?>
    <h3 class="line">アートメイク</h3>
    <h3>指名料</h3>
    <?php echo do_shortcode('[table id=32 /]'); ?>
    <?php
    /*
	<div class="trainee">
      <p>Premium Artistは完全指名制となります。</p>
    </div>
	*/
    ?>
    <h3>メニュー</h3>
    <?php echo do_shortcode('[table id=34 /]'); ?>
    <?php $myfield = scf::get('trainee_txt'); if( !empty( $myfield )){ ?>
    <div class="trainee">
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <?php } ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--アートメイク(渋谷)-->
    <?php if ( is_single( array ( 'shibuya' )) ) : ?>
    <h3 class="line">アートメイク</h3>
    <h3>指名料</h3>
    <?php echo do_shortcode('[table id=8 /]'); ?>
    <div class="trainee">
      <p>Premium Artistは完全指名制となります。</p>
    </div>
    <h3>2回コース</h3>
    <?php echo do_shortcode('[table id=9 /]'); ?>
    <h3>1回コース</h3>
    <?php echo do_shortcode('[table id=25/]'); ?>
    <?php $myfield = scf::get('trainee_tit'); if( !empty( $myfield )){ ?>
    <div class="trainee">
      <h4>
        <?php $myfield = scf::get('trainee_tit'); echo $myfield; ?>
      </h4>
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <?php } ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--アートメイク(渋谷T)-->
    <?php if ( is_single( array ( 'shibuya_test2304' , 'shinjuku' )) ) : ?>
    <h3 class="line">アートメイク</h3>
    <h3>指名料/回</h3>
    <?php echo do_shortcode('[table id=32 /]'); ?>
    <?php
    /*
	<div class="trainee">
      <p>Premium Artistは完全指名制となります。</p>
    </div>
	*/
    ?>
    <h3>メニュー</h3>
    <?php echo do_shortcode('[table id=33 /]'); ?>
    <?php $myfield = scf::get('trainee_txt'); if( !empty( $myfield )){ ?>
    <div class="trainee">
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <?php } ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--アートメイク(大阪)-->
    <?php if ( is_single( array ( 'osaka' , 'テスト' )) ) : ?>
    <h3 class="line">アートメイク</h3>
    <h3>指名料</h3>
    <?php echo do_shortcode('[table id=14 /]'); ?>
    <h3>2回コース</h3>
    <?php echo do_shortcode('[table id=15 /]'); ?>
    <?php $myfield = scf::get('trainee_tit'); if( !empty( $myfield )){ ?>
    <div class="trainee">
      <h4>
        <?php $myfield = scf::get('trainee_tit'); echo $myfield; ?>
      </h4>
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <?php } ?>
    <div class="trainee">
      <p>リタッチは当院で施術歴がある方のみ施術いたします。<br>
        他院での施術の方は対応しておりません。ご了承くださいませ。</p>
    </div>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--アートメイク(新宿)-->
    <?php if ( is_single( array (  'テスト' )) ) : ?>
    <h3 class="line">アートメイク</h3>
    <h3>指名料</h3>
    <?php echo do_shortcode('[table id=17 /]'); ?>
    <h3>2回コース</h3>
    <?php echo do_shortcode('[table id=18 /]'); ?>
    <h3>1回コース</h3>
    <?php echo do_shortcode('[table id=27 /]'); ?>
    <?php $myfield = scf::get('trainee_tit'); if( !empty( $myfield )){ ?>
    <div class="trainee">
      <h4>
        <?php $myfield = scf::get('trainee_tit'); echo $myfield; ?>
      </h4>
      <p>
        <?php $myfield = scf::get('trainee_txt'); echo nl2br( $myfield ); ?>
      </p>
    </div>
    <?php } ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--////////////////////////////////////////////////////////////////////////////////////--> 
    
    <!--美容皮膚科見出し-->
    <?php if ( is_single( array ( 'shibuya' , 'sapporo' , 'shinjuku' , 'fukuoka' )) ) : ?>
    <h3 class="line" id="hifuka-price">美容皮膚科</h3>
    <?php else:?>
    <?php endif; ?>
    
    <!--ダーマペン-->
    <?php if ( is_single( array ( 'shinjuku' , 'テスト' )) ) : ?>
    <h3>ダーマペン4</h3>
    <?php echo do_shortcode('[table id=43 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <h3>ダーマペン4オプション</h3>
    <?php echo do_shortcode('[table id=44 /]'); ?>
    <p class="zeikomi">料金はすべて税込です<br>
      ※1 成長因子のコースには追加いただけません</p>
    <?php else:?>
    <?php endif; ?>
    <!--ボトックス-->
    <?php if ( is_single( array ( 'fukuoka' , 'テスト' )) ) : ?>
    <h3>部位別ボトックス①</h3>
    <?php echo do_shortcode('[table id=57 /]'); ?>
    <h3>部位別ボトックス②</h3>
    <?php echo do_shortcode('[table id=58 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <div class="line-reserve">
      <p>福岡院でのボトックス注射はお電話またはLINEにて受付しております。</p>
      <dl class="tel">
        <dt> 電話受付</dt>
        <dd> <a href="tel:0927398768">0927398768</a></dd>
      </dl>
      <dl class="line">
        <dt>LINE受付</dt>
        <dd><img src="https://www.dazzyclinic.jp/wp-content/uploads/2025/05/fukuoka_yoyaku_QR.jpg" style="width: 50%;max-width: 170px;">
          <p>
            ・お名前<br>
            ・生年月日<br>
            ・連絡先<br>
			・ボトックス希望の旨と、上記を明記の上ご連絡ください。</p>
        </dd>
      </dl>
    </div>
    <?php else:?>
    <?php endif; ?>
    
    <!--HIFU-->
    <?php if ( is_single( array ( 'sapporo' , 'テスト' )) ) : ?>
    <h3>HIFU(ハイフ)</h3>
    <?php echo do_shortcode('[table id=54 /]'); ?>
    <div class="trainee">
      <p>当院のHIFU治療にはウルトラセルQ＋を使用いたします。</p>
    </div>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--HIFU-->
    <?php if ( is_single( array ( 'fukuoka_skin' , 'テスト' )) ) : ?>
    <div class="btn"><a href="https://dazzyclinic.jp/skin/pricelist/">料金表はこちら</a> </div>
    <?php else:?>
    <?php endif; ?>
    
    <!--////////////////////////////////////////////////////////////////////////////////////--> 
    
    <!--脱毛-->
    <?php if ( is_single( array ( 'shibuya' ,  'shinjuku' ,  'fukuoka' )) ) : ?>
    <h3 class="line" id="datumo">医療脱毛</h3>
    <?php else:?>
    <?php endif; ?>
    
    <!--脱毛-->
    <?php if ( is_single( array ( 'shinjuku' , 'テスト' )) ) : ?>
    <h3>都度脱毛(女性)</h3>
    <?php echo do_shortcode('[table id=41 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <h3>都度脱毛(男性)</h3>
    <?php echo do_shortcode('[table id=42 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
	  
    <!--脱毛-->
    <?php if ( is_single( array ( 'fukuoka' , 'テスト' )) ) : ?>
    <h3>都度脱毛(女性)</h3>
    <?php echo do_shortcode('[table id=60 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <h3>都度脱毛(男性)</h3>
    <?php echo do_shortcode('[table id=62 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <div class="line-reserve">
		<p>福岡院での脱毛はお電話またはLINEにて受付しております。</p>
      <dl class="tel">
        <dt> 電話受付</dt>
        <dd> <a href="tel:0927398768">0927398768</a></dd>
      </dl>
      <dl class="line">
        <dt>LINE受付</dt>
        <dd><img src="https://www.dazzyclinic.jp/wp-content/uploads/2025/05/fukuoka_yoyaku_QR.jpg" style="width: 50%;max-width: 170px;">
          <p>
            ・お名前<br>
            ・生年月日<br>
            ・連絡先<br>
			・脱毛希望の旨と、上記を明記の上ご連絡ください。</p>
        </dd>
      </dl>
    </div>
    <?php else:?>
    <?php endif; ?>
    
    <!--////////////////////////////////////////////////////////////////////////////////////--> 
    
    <!--診療メニュー見出し-->
    <?php if ( is_single( array ( 'shibuya' , 'sapporo' , 'fukuoka' , 'shinjuku' )) ) : ?>
    <h3 class="line">診療メニュー</h3>
    <?php else:?>
    <?php endif; ?>
    
    <!--ピル処方-->
    <?php if ( is_single( array ( 'shibuya' , 'テスト' , 'shinjuku' )) ) : ?>
    <h3>ピル処方（マーベロン・トリキュラー）</h3>
    <?php echo do_shortcode('[table id=13 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--GLP-1-->
    <?php if ( is_single( array ( 'shibuya' , 'sapporo'  )) ) : ?>
    <h3>GLP-1注射</h3>
    <?php echo do_shortcode('[table id=12 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php endif; ?>
    <?php if ( is_single( array (  'fukuoka'  )) ) : ?>
    <h3>GLP-1注射</h3>
    <?php echo do_shortcode('[table id=12 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <h3>GLP-1注射(マンジャロ)</h3>
    <?php echo do_shortcode('[table id=59 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php endif; ?>
    <?php if ( is_single( array (  'shinjuku'  )) ) : ?>
    <h3>GLP-1注射</h3>
    <?php echo do_shortcode('[table id=56 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php endif; ?>
    
    <!--////////////////////////////////////////////////////////////////////////////////////--> 
    
    <!--点滴メニュー-->
    <?php if ( is_single( array ( 'shinjuku' , 'fukuoka' )) ) : ?>
    <h3 class="line" id="tenteki">点滴メニュー</h3>
    <?php else:?>
    <?php endif; ?>
    
    <!--高濃度ビタミンC-->
    <?php if ( is_single( array ( 'shinjuku' )) ) : ?>
    <h3>高濃度ビタミンC</h3>
    <?php echo do_shortcode('[table id=35 /]'); ?>
    <div class="trainee">
      <p>高濃度ビタミンC点滴が初めての方は初回のみG6PD検査が必要となります（別途4,400円）</p>
    </div>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    <?php if ( is_single( array ( 'fukuoka' )) ) : ?>
    <h3>高濃度ビタミンC</h3>
    <?php echo do_shortcode('[table id=49 /]'); ?>
    <div class="trainee">
      <p>高濃度ビタミンC点滴が初めての方は初回のみG6PD検査が必要となります（別途4,400円）</p>
    </div>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--その他の点滴-->
    <?php if ( is_single( array ( 'shinjuku' , 'fukuoka' )) ) : ?>
    <h3>点滴各種</h3>
    <?php echo do_shortcode('[table id=36 /]'); ?>
    <p class="zeikomi" style="margin-bottom: 1em">料金はすべて税込です</p>
    <h4>点滴による主なリスク・副作用</h4>
    <?php echo do_shortcode('[table id=46 /]'); ?>
    <?php else:?>
    <?php endif; ?>
    
    <!--NMN点滴-->
    <?php if ( is_single( array ( 'shinjuku' )) ) : ?>
    <h3>NMN点滴</h3>
    <?php echo do_shortcode('[table id=37 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--エクソソーム点滴-->
    <?php /*<?php if ( is_single( array ( 'shinjuku' )) ) : ?>
<h3>エクソソーム点滴</h3>
<?php echo do_shortcode('[table id=38 /]'); ?>
<p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>*/?>
    
    <!--////////////////////////////////////////////////////////////////////////////////////--> 
    
    <!--注射メニュー-->
    <?php if ( is_single( array ( 'shinjuku' , 'fukuoka' )) ) : ?>
    <h3 class="line">注射メニュー</h3>
    <?php else:?>
    <?php endif; ?>
    
    <!--注射メニュー-->
    <?php if ( is_single( array ( 'shinjuku' )) ) : ?>
    <h3>注射メニュー</h3>
    <?php echo do_shortcode('[table id=39 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    <?php if ( is_single( array ( 'fukuoka' )) ) : ?>
    <h3>注射メニュー</h3>
    <?php echo do_shortcode('[table id=52 /]'); ?>
    <p class="zeikomi">料金はすべて税込です</p>
    <?php else:?>
    <?php endif; ?>
    
    <!--オプションで点滴に追加できるもの-->
    <?php if ( is_single( array ( 'shinjuku' )) ) : ?>
    <h3>オプション</h3>
    <?php echo do_shortcode('[table id=40 /]'); ?>
    <p class="zeikomi" style="margin-bottom: 1em">料金はすべて税込です</p>
    <h4>注射による主なリスク・副作用</h4>
    <?php echo do_shortcode('[table id=47 /]'); ?>
    <?php else:?>
    <?php endif; ?>
    <?php if ( is_single( array ( 'fukuoka' )) ) : ?>
    <h3>オプション</h3>
    <?php echo do_shortcode('[table id=53 /]'); ?>
    <p class="zeikomi" style="margin-bottom: 1em">料金はすべて税込です</p>
    <h4>注射による主なリスク・副作用</h4>
    <?php echo do_shortcode('[table id=47 /]'); ?>
    <?php else:?>
    <?php endif; ?>
    
    <!--/price--> 
  </section>
  
  <!--map---------------->
  <section class="map" id="map">
    <?php $myfield = scf::get('clinic_map'); echo nl2br( $myfield ); ?>
  </section>
  
  <!--map_guide---------------->
  <?php if ( is_single( array ( 'osaka' , 'テスト' )) ) : ?>
  <section class="map_guide">
    <h2>Access<span>駅からの道順</span></h2>
    <!--1-->
    <p class="js_tit map_guide_tit">心斎橋駅3番出口</p>
    <div class="map_guide_cnts">
      <div class="inner">
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/1_1.webp"></dt>
          <dd>
            <p>Step.1</p>
            心斎橋駅3番出口</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/1_2.webp"></dt>
          <dd>
            <p>Step.2</p>
            TUDORの看板が見えますので
            そのまま直進してください。(距離にして約150m)</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/1_3.webp"></dt>
          <dd>
            <p>Step.3</p>
            セブンイレブン心斎橋長堀通西店の 右側がビルの入口です</dd>
        </dl>
      </div>
    </div>
    
    <!--2-->
    <p class="js_tit map_guide_tit">心斎橋駅 北改札 4B出口</p>
    <div class="map_guide_cnts">
      <div class="inner">
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_1.webp"></dt>
          <dd>
            <p>Step.1</p>
            心斎橋駅北改札4B出口</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_2.webp"></dt>
          <dd>
            <p>Step.2</p>
            横断歩道を渡り右折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_3.webp"></dt>
          <dd>
            <p>Step.3</p>
            日光ホテル前を70m直進</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_4.webp"></dt>
          <dd>
            <p>Step.4</p>
            新橋の交差点を渡って左折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_5.webp"></dt>
          <dd>
            <p>Step.5</p>
            TUDORの看板が見えますので
            そのまま直進してください。(距離にして約150m)</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_6.webp"></dt>
          <dd>
            <p>Step.6</p>
            セブンイレブン心斎橋長堀通西店の 右側がビルの入口です</dd>
        </dl>
      </div>
    </div>
    
    <!--3-->
    <p class="js_tit map_guide_tit">御堂筋線 2番出口</p>
    <div class="map_guide_cnts">
      <div class="inner">
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_1.webp"></dt>
          <dd>
            <p>Step.1</p>
            御堂筋線2番出口右折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_2.webp"></dt>
          <dd>
            <p>Step.2</p>
            100m直進</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_3.webp"></dt>
          <dd>
            <p>Step.3</p>
            突き当りを右折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_4.webp"></dt>
          <dd>
            <p>Step.4</p>
            右奥側に北12エレベーターで1Fへ</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_5.webp"></dt>
          <dd>
            <p>Step.5</p>
            地上に出て右折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_6.webp"></dt>
          <dd>
            <p>Step.6</p>
            セブンイレブン心斎橋長堀通西店の 右側がビルの入口です</dd>
        </dl>
      </div>
    </div>
    
    <!--4-->
    <p class="js_tit map_guide_tit">長堀鶴見緑地線　四ツ橋駅</p>
    <div class="map_guide_cnts">
      <div class="inner">
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/4_1.webp"></dt>
          <dd>
            <p>Step.1</p>
            改札を出て右折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/4_2.webp"></dt>
          <dd>
            <p>Step.2</p>
            突き当り左折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_4.webp"></dt>
          <dd>
            <p>Step.3</p>
            右奥側に北12エレベーターで1Fへ</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/3_5.webp"></dt>
          <dd>
            <p>Step.4</p>
            地上に出て右折</dd>
        </dl>
        <dl>
          <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/10/2_6.webp"></dt>
          <dd>
            <p>Step.5</p>
            セブンイレブン心斎橋長堀通西店の 右側がビルの入口です</dd>
        </dl>
      </div>
    </div>
  </section>
  <?php endif; ?>
  
  <!------------------>
  <?php if ( is_single( array ( 'テスト' )) ) : ?>
  <section class="page_clinic">
    <h2>Doctor<span>ドクター </span></h2>
    <div class="shinjyuku_dr">
      <?php
      $myfield = scf::get( 'dr_kao' );
      echo wp_get_attachment_image( $myfield, 'large' );
      ?>
    </div>
  </section>
  <?php else:?>
  <?php $myfield = scf::get('dr_name'); if( !empty( $myfield )){ ?>
  <section class="page_clinic">
    <h2>Doctor<span>ドクター </span></h2>
    <dl class="dr_box">
      <?php $mycheck = scf::get('dr_kao'); if( $mycheck ){ ?>
      <dt>
        <?php
        $myfield = scf::get( 'dr_kao' );
        echo wp_get_attachment_image( $myfield, 'large' );
        ?>
      </dt>
      <?php } ?>
      <dd>
        <h3><span>
          <?php $myfield = scf::get('dr_post'); echo $myfield; ?>
          </span>
          <?php $myfield = scf::get('dr_name'); echo $myfield; ?>
        </h3>
        <?php $myfield = scf::get('dr_aisatu'); if( !empty( $myfield )){ ?>
        <div class="message">
          <h4>ごあいさつ</h4>
          <p> <?php echo $myfield; ?> </p>
        </div>
        <?php } ?>
        <div class="career_box">
          <?php $value = get_post_meta($post->ID, 'dr_career', true);?>
          <?php if(empty($value)):?>
          <?php else:?>
          <ul>
            <h4>経歴</h4>
            <?php $myfield = SCF::get( 'dr_career_box' ); foreach ( $myfield as $fields ) { ?>
            <?php if($fields['dr_career']):?>
            <li>
              <?php if($fields['dr_career_year']):?>
              <span><?php echo ($fields['dr_career_year']); ?></span>
              <?php endif;?>
              <?php echo ($fields['dr_career']); ?>
              <?php endif;?>
            </li>
            <?php } ?>
          </ul>
          <?php endif;?>
          <?php $value = get_post_meta($post->ID, 'dr_affiliation', true);?>
          <?php if(empty($value)):?>
          <?php else:?>
          <ul>
            <h4>所属学会</h4>
            <?php $myfield = SCF::get( 'dr_affiliation_box' ); foreach ( $myfield as $fields ) { ?>
            <?php if($fields['dr_affiliation']):?>
            <li> <?php echo ($fields['dr_affiliation']); ?>
              <?php endif;?>
            </li>
            <?php } ?>
          </ul>
          <?php endif;?>
          <?php $value = get_post_meta($post->ID, 'dr_license', true);?>
          <?php if(empty($value)):?>
          <?php else:?>
          <ul>
            <h4>資格</h4>
            <?php $myfield = SCF::get( 'dr_license_box' ); foreach ( $myfield as $fields ) { ?>
            <?php if($fields['dr_license']):?>
            <li> <?php echo ($fields['dr_license']); ?>
              <?php endif;?>
            </li>
            <?php } ?>
          </ul>
          <?php endif;?>
        </div>
      </dd>
    </dl>
  </section>
  <?php } ?>
  <?php endif; ?>
  
  <!--Staff---------------->
  <?php $value = get_post_meta($post->ID, 'staff_name', true);?>
  <?php if(empty($value)):?>
  <?php else:?>
  <section class="page_clinic bg_gray">
    <h2>Staff<span> スタッフ </span></h2>
    <div class="staff_flex"> 
      <!------------------>
      <?php $value = get_post_meta($post->ID, 'staff_name', true);?>
      <?php if(empty($value)):?>
      <?php else:?>
      <?php $fields = SCF::get( 'staff_box' ); foreach ( $fields as $fields ) { ?>
      <div class="staff_box">
        <?php if($fields['staff_name']):?>
        <h3><?php echo ($fields['staff_name']); ?>
          <?php if($fields['staff_appoint']):?>
          <p><span>指名料</span><?php echo ($fields['staff_appoint']); ?>円/回</p>
          <?php endif;?>
        </h3>
        <?php endif;?>
        <dl>
          <dt>
            <?php if($fields['staff_kao']):?>
            <?php echo wp_get_attachment_image( $fields['staff_kao'] ,'large'); ?>
            <?php endif;?>
          </dt>
          <dd>
            <h4>経歴</h4>
            <?php if($fields['staff_career']):?>
            <ul>
              <?php echo ($fields['staff_career']); ?>
            </ul>
            <?php endif;?>
            <?php if($fields['staff_txt']):?>
            <h4>ごあいさつ</h4>
            <div class="message">
              <p><?php echo ($fields['staff_txt']); ?></p>
            </div>
            <?php endif;?>
          </dd>
        </dl>
        <div class="flex">
          <h4>施術例</h4>
          <? /*<?php if($fields['staff_img1']):?>
<div class="sample"><?php echo wp_get_attachment_image( $fields['staff_img1'] ,'full'); ?><span>施術名:<?php echo ($fields['staff_label1']); ?></span></div>
          <?php endif;?>
          <?php if($fields['staff_img2']):?>
<div class="sample"><?php echo wp_get_attachment_image( $fields['staff_img2'] ,'full'); ?><span>施術名:<?php echo ($fields['staff_label2']); ?></span></div>
          <?php endif;?>
          <?php if($fields['staff_img3']):?>
<div class="sample"><?php echo wp_get_attachment_image( $fields['staff_img3'] ,'full'); ?><span>施術名:<?php echo ($fields['staff_label3']); ?></span></div>
          <?php endif;?>*/ ?>
          <div class="ig_btn"><a href="https://www.instagram.com/<?php echo ($fields['staff_ig']); ?>"><span>施術例はこちら</span><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/03/icon_ig.png">@<?php echo ($fields['staff_ig']); ?></a></div>
        </div>
      </div>
      <?php } ?>
      <?php endif;?>
      <!------------------> 
    </div>
  </section>
  <?php endif;?>
  
  <!------------------>
  <?php if ( is_single( array ( 'fukuoka_skin' )) ) : ?>
  <section class="page_cnts">
    <h2>Group<span>近隣店舗の紹介</span></h2>
    <div class="cliniclist" style="margin-top: 2em;"> 
      <!--福岡-->
      <dl>
        <dt> <a href="https://www.dazzyclinic.jp/cliniclist/fukuoka/">
          <?php $myfield = scf::get('clinic_img' , 622 ); echo wp_get_attachment_image( $myfield, 'large' ); ?>
          </a>
          <ul>
            <?php $term = scf::get('clinic_tag' , 622); foreach ($term as $field) { echo "<li>", get_the_category_by_ID($field) , "</li>"; } ?>
          </ul>
          <div>
            <h3><?php echo nl2br ( $fields = scf::get('clinic_name_s', 622 )); ?></h3>
            <div class="map"><a href="https://www.dazzyclinic.jp/cliniclist/fukuoka/#map">MAP</a></div>
          </div>
        </dt>
        <dd>
          <p><?php echo nl2br ( $fields = scf::get('clinic_station', 622 )); ?></p>
          <div class="time">診療時間: <?php echo nl2br ( $fields = scf::get('clinic_time', 622 )); ?></div>
          <div class="btn"><a href="https://www.dazzyclinic.jp/cliniclist/fukuoka/">詳しくはこちら</a></div>
        </dd>
      </dl>
    </div>
  </section>
  <?php endif; ?>
  
  <!------------------>
  <?php/*
  <?php if ( is_single( array ( 'fukuoka' )) ) : ?>
  <section class="page_cnts">
    <h2>Group<span>近隣店舗の紹介</span></h2>
    <div class="cliniclist" style="margin-top: 2em;"> 
      <!--福岡スキン-->
      <dl>
        <dt> <a href="https://www.dazzyclinic.jp/cliniclist/fukuoka_skin/">
          <?php $myfield = scf::get('clinic_img' , 1955 ); echo wp_get_attachment_image( $myfield, 'large' ); ?>
          </a>
          <ul>
            <?php $term = scf::get('clinic_tag' , 1955); foreach ($term as $field) { echo "<li>", get_the_category_by_ID($field) , "</li>"; } ?>
          </ul>
          <div>
            <h3><?php echo nl2br ( $fields = scf::get('clinic_name_s', 1955 )); ?></h3>
            <div class="map"><a href="https://www.dazzyclinic.jp/cliniclist/fukuoka_skin/#map">MAP</a></div>
          </div>
        </dt>
        <dd>
          <p><?php echo nl2br ( $fields = scf::get('clinic_station', 1955 )); ?></p>
          <div class="time">診療時間: <?php echo nl2br ( $fields = scf::get('clinic_time', 1955 )); ?></div>
          <div class="btn"><a href="https://www.dazzyclinic.jp/cliniclist/fukuoka_skin/">詳しくはこちら</a></div>
        </dd>
      </dl>
    </div>
  </section>
  <?php endif; ?>
  */?>
  
  <!--pill------------------->
  <section class="cdetail_btm_txt">
    <p>
      <?php $myfield = scf::get('cdetail_btm_txt'); echo $myfield; ?>
    </p>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
